/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.permissions.PermissionHelper;
import org.nuxeo.ecm.permissions.TransientUserPermissionHelper;
import org.nuxeo.runtime.api.Framework;

public class ACEStatusUpdatedListener
implements PostCommitFilteringEventListener {
    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        String repositoryName = (String)((Object)ctx.getProperty("repositoryName"));
        Map refsToACEs = (Map)((Object)ctx.getProperty("documentRefs"));
        if (repositoryName == null || refsToACEs == null) {
            return;
        }
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);){
            refsToACEs.keySet().stream().filter(arg_0 -> ((CoreSession)session).exists(arg_0)).forEach(ref -> {
                DocumentModel doc = session.getDocument(ref);
                this.checkForEffectiveACE(session, doc, (List)refsToACEs.get(ref));
            });
        }
    }

    protected void checkForEffectiveACE(CoreSession session, DocumentModel doc, List<ACE> aces) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        for (ACE ace : aces) {
            if (!ace.isGranted()) continue;
            switch (ace.getStatus()) {
                case EFFECTIVE: {
                    String aclName = (String)((Object)ace.getContextData("changedACLName"));
                    if (aclName == null) break;
                    Framework.doPrivileged(() -> {
                        try (Session dirSession = directoryService.open("aceinfo");){
                            String id = PermissionHelper.computeDirectoryId(doc, aclName, ace.getId());
                            DocumentModel entry = dirSession.getEntry(id);
                            if (entry != null) {
                                Boolean notify = (Boolean)entry.getPropertyValue("aceinfo:notify");
                                String comment = (String)((Object)entry.getPropertyValue("aceinfo:comment"));
                                if (Boolean.TRUE.equals(notify)) {
                                    ace.putContextData("comment", (Serializable)((Object)comment));
                                    PermissionHelper.firePermissionNotificationEvent(session, doc, aclName, ace);
                                }
                            }
                        }
                    });
                    break;
                }
                case ARCHIVED: {
                    TransientUserPermissionHelper.revokeToken(ace.getUsername(), doc);
                }
            }
        }
    }

    public boolean acceptEvent(Event event) {
        return "ACEStatusUpdated".equals(event.getName());
    }
}

