/*
 * Copyright 2000-2014 Vaadin Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.sass.internal.parser.function;

import com.vaadin.sass.internal.parser.LexicalUnitImpl;
import com.vaadin.sass.internal.parser.ParseException;

public class UnitlessFunctionGenerator extends
        AbstractSingleParameterFunctionGenerator {

    private static String[] argumentNames = { "number" };

    public UnitlessFunctionGenerator() {
        super(createArgumentList(argumentNames, false), "unitless");
    }

    @Override
    protected LexicalUnitImpl computeForParam(String functionName,
            LexicalUnitImpl firstParam) {
        if (!firstParam.isNumber()) {
            throw new ParseException("The parameter of " + functionName
                    + "() must be a number", firstParam);
        }
        Boolean value = "".equals(firstParam.getDimensionUnitText());
        LexicalUnitImpl result = LexicalUnitImpl.createIdent(
                firstParam.getLineNumber(), firstParam.getColumnNumber(),
                value.toString());
        return result;
    }
}