/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class ParamCollector {
    public static final String Key = "collector";
    private static final String SKIP_SECTIONS_KEY = "nuxeo.wizard.skippedsections";
    private List<String> sectionsToSkip;
    private ConfigurationGenerator configurationGenerator;
    protected Map<String, String> configurationParams = new HashMap();
    protected Map<String, String> connectParams = new HashMap();

    public ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public ParamCollector() {
        this.configurationGenerator = new ConfigurationGenerator();
        this.configurationGenerator.init();
        String skipSections = this.configurationGenerator.getUserConfig().getProperty(SKIP_SECTIONS_KEY, "");
        this.sectionsToSkip = Arrays.asList(skipSections.split(","));
    }

    public boolean isSectionSkipped(String section) {
        return this.sectionsToSkip.contains(section);
    }

    public void addConfigurationParam(String name, String value) {
        if (value == null) {
            this.configurationParams.remove(name);
        } else {
            this.configurationParams.put(name, value);
        }
    }

    public void addConnectParam(String name, String value) {
        this.configurationParams.put(name, value);
    }

    public Map<String, String> getConfigurationParams() {
        return this.configurationParams;
    }

    public Map<String, String> getChangedParameters() {
        return this.configurationGenerator.getChangedParameters(this.configurationParams);
    }

    public String getConfigurationParam(String name) {
        String param = (String)this.configurationParams.get(name);
        if (param == null) {
            param = this.configurationGenerator.getUserConfig().getProperty(name, "");
        }
        return param;
    }

    public String getConfigurationParamValue(String name) {
        return (String)this.configurationParams.get(name);
    }

    public Map<String, String> getConnectParams() {
        return this.connectParams;
    }

    public void collectConfigurationParams(HttpServletRequest req) {
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String value;
            String name = (String)names.nextElement();
            if (!name.startsWith("org.nuxeo.") && !name.startsWith("nuxeo.") && !name.startsWith("mail.") || (value = req.getParameter(name)).isEmpty() && (!value.isEmpty() || !this.configurationParams.containsKey(name))) continue;
            this.addConfigurationParam(name, value);
        }
    }

    public void changeDBTemplate(String templateName) {
        ArrayList<String> keys = new ArrayList<String>();
        this.configurationGenerator.changeDBTemplate(templateName);
        for (String key : this.configurationParams.keySet()) {
            if (!key.startsWith("nuxeo.db")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.configurationParams.remove(key);
        }
    }
}

