/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.nuxeo.wizard.download.DownloadPackage;
import org.nuxeo.wizard.download.DownloadablePackageOption;
import org.nuxeo.wizard.download.DownloadablePackageOptions;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadDescriptorParser {
    protected static final Log log = LogFactory.getLog(DownloadDescriptorParser.class);
    protected static int nodeCounter = 0;

    public static Document parse(InputStream in) {
        Document document = null;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(in);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static DownloadablePackageOptions parsePackages(InputStream in) {
        DownloadablePackageOptions options = new DownloadablePackageOptions();
        ArrayList<DownloadPackage> pkgs = new ArrayList<DownloadPackage>();
        Document document = DownloadDescriptorParser.parse((InputStream)in);
        if (document != null) {
            DownloadPackage pkg;
            String baseUrl = document.getRootElement().element("packageDefinitions").attributeValue("baseUrl");
            for (Object el : document.getRootElement().element("packageDefinitions").elements("package")) {
                DownloadPackage pkg2 = DownloadDescriptorParser.readPackageDefinition((Element)((Element)el), (String)baseUrl);
                if (pkg2 == null) continue;
                pkgs.add(pkg2);
            }
            options.setAllPackages(pkgs);
            Element install = document.getRootElement().element("install");
            if (install.element("common") != null) {
                for (Object el : install.element("common").elements("package")) {
                    pkg = DownloadDescriptorParser.readCommonPackage((Element)((Element)el), pkgs);
                    if (pkg == null) continue;
                    options.addCommonPackage(pkg);
                }
            }
            nodeCounter = 0;
            for (Object el : install.element("packageOptions").elements("package")) {
                pkg = DownloadDescriptorParser.readPackageOptions((Element)((Element)el), pkgs);
                if (pkg == null) continue;
                options.addOptions((DownloadablePackageOption)pkg);
            }
            if (document.getRootElement().element("presets") != null) {
                for (Object el : document.getRootElement().element("presets").elements("preset")) {
                    Element preset = (Element)el;
                    String presetId = preset.attribute("id").getValue();
                    String presetLabel = preset.attribute("label").getValue();
                    String pkgList = preset.getText();
                    String[] presetPackages = pkgList.split(",");
                    options.addPreset(presetId, presetLabel, presetPackages);
                }
            }
        }
        return options;
    }

    protected static DownloadPackage readPackageDefinition(Element el, String baseUrl) {
        String id = el.attribute("id").getValue();
        if (id != null) {
            String implies;
            DownloadPackage pkg = new DownloadPackage(id);
            String bUrl = el.attributeValue("baseUrl");
            if (bUrl == null) {
                bUrl = baseUrl;
            }
            pkg.setLabel(el.attributeValue("label"));
            pkg.setFilename(el.attributeValue("filename"));
            pkg.setMd5(el.attributeValue("md5"));
            pkg.setBaseUrl(bUrl);
            pkg.setColor(el.attributeValue("color"));
            pkg.setTextColor(el.attributeValue("textcolor"));
            pkg.setShortLabel(el.attributeValue("shortlabel"));
            String url = el.attributeValue("url");
            if (url != null) {
                pkg.setDownloadUrl(url);
            }
            if ((implies = el.attributeValue("implies")) != null && !implies.trim().equals("")) {
                String[] deps = implies.split(",");
                pkg.addDeps(deps);
            }
            return pkg;
        }
        return null;
    }

    protected static DownloadPackage readCommonPackage(Element el, List<DownloadPackage> pkgs) {
        String ref = el.attributeValue("ref");
        for (DownloadPackage pkg : pkgs) {
            if (!pkg.getId().equals(ref)) continue;
            return pkg;
        }
        log.error((Object)("Unable to find common package for ref " + ref));
        return null;
    }

    protected static DownloadablePackageOption readPackageOptions(Element el, List<DownloadPackage> pkgs) {
        String id;
        String ref = el.attributeValue("ref");
        DownloadPackage targetPkg = null;
        if (ref != null) {
            for (DownloadPackage pkg : pkgs) {
                if (!pkg.getId().equals(ref)) continue;
                targetPkg = pkg;
                break;
            }
            if (targetPkg == null) {
                log.error((Object)("Unable to find package for ref " + ref));
                return null;
            }
        }
        if ((id = el.attributeValue("ref")) == null) {
            id = ref;
        }
        DownloadablePackageOption pkgOption = id != null ? new DownloadablePackageOption(targetPkg, id) : new DownloadablePackageOption(targetPkg, ++nodeCounter);
        String label = el.attributeValue("label");
        if (label != null) {
            pkgOption.setLabel(label);
        }
        pkgOption.setExclusive(el.attributeValue("exclusive"));
        for (Object child : el.elements()) {
            DownloadablePackageOption childPkg = DownloadDescriptorParser.readPackageOptions((Element)((Element)child), pkgs);
            if (childPkg == null) continue;
            pkgOption.addChildPackage(childPkg);
        }
        return pkgOption;
    }
}

