/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.wizard.download.DownloadDescriptorParser;
import org.nuxeo.wizard.download.DownloadPackage;
import org.nuxeo.wizard.download.DownloadablePackageOptions;
import org.nuxeo.wizard.download.PackageDownloader;
import org.nuxeo.wizard.download.PendingDownload;
import org.nuxeo.wizard.download.Preset;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackageDownloader {
    protected static final Log log = LogFactory.getLog(PackageDownloader.class);
    public static final String PACKAGES_XML = "packages.xml";
    public static final String PACKAGES_DEFAULT_SELECTION = "packages-default-selection.properties";
    public static final String PACKAGES_DEFAULT_SELECTION_PRESETS = "preset";
    public static final String PACKAGES_DEFAULT_SELECTION_PACKAGES = "packages";
    protected static final int NB_DOWNLOAD_THREADS = 3;
    protected static final int NB_CHECK_THREADS = 1;
    protected static final int QUEUESIZE = 20;
    public static final String BASE_URL_KEY = "nuxeo.wizard.packages.url";
    public static final String DEFAULT_BASE_URL = "http://cdn.nuxeo.com/";
    protected CopyOnWriteArrayList<PendingDownload> pendingDownloads = new CopyOnWriteArrayList();
    protected static PackageDownloader instance;
    protected DefaultHttpClient httpClient;
    protected Boolean canReachServer = null;
    protected DownloadablePackageOptions downloadOptions;
    protected static final String DIGEST = "MD5";
    protected static final int DIGEST_CHUNK = 102400;
    boolean downloadStarted = false;
    protected String lastSelectionDigest;
    protected final AtomicInteger dwThreadCount = new AtomicInteger(0);
    protected final AtomicInteger checkThreadCount = new AtomicInteger(0);
    protected String baseUrl;
    protected ConfigurationGenerator configurationGenerator = null;
    protected ThreadPoolExecutor download_tpe = new ThreadPoolExecutor(3, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    protected ThreadPoolExecutor check_tpe = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);

    protected ConfigurationGenerator getConfig() {
        if (this.configurationGenerator == null) {
            this.configurationGenerator = new ConfigurationGenerator();
            this.configurationGenerator.init();
        }
        return this.configurationGenerator;
    }

    protected String getBaseUrl() {
        if (this.baseUrl == null) {
            String base = this.getConfig().getUserConfig().getProperty("nuxeo.wizard.packages.url", "");
            if ("".equals(base)) {
                base = "http://cdn.nuxeo.com/nuxeo-" + this.getConfig().getUserConfig().getProperty("org.nuxeo.ecm.product.version") + "/mp/";
            }
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            this.baseUrl = base;
        }
        return this.baseUrl;
    }

    protected PackageDownloader() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(registry);
        cm.setMaxTotal(3);
        cm.setDefaultMaxPerRoute(3);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
    }

    public static synchronized PackageDownloader instance() {
        if (instance == null) {
            instance = new PackageDownloader();
            PackageDownloader.instance.download_tpe.prestartAllCoreThreads();
            PackageDownloader.instance.check_tpe.prestartAllCoreThreads();
        }
        return instance;
    }

    public static void reset() {
        if (instance != null) {
            instance.shutdown();
            instance = null;
        }
    }

    public void setProxy(String proxy, int port, String login, String password, String NTLMHost, String NTLMDomain) {
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy, port);
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            if (login != null) {
                if (NTLMHost != null && !NTLMHost.trim().isEmpty()) {
                    NTCredentials ntlmCredentials = new NTCredentials(login, password, NTLMHost, NTLMDomain);
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxy, port), (Credentials)ntlmCredentials);
                } else {
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxy, port), (Credentials)new UsernamePasswordCredentials(login, password));
                }
            } else {
                this.httpClient.getCredentialsProvider().clear();
            }
        } else {
            this.httpClient.getParams().removeParameter("http.route.default-proxy");
            this.httpClient.getCredentialsProvider().clear();
        }
    }

    protected String getSelectionDigest(List<String> ids) {
        ArrayList<String> lst = new ArrayList<String>(ids);
        Collections.sort(lst);
        StringBuffer sb = new StringBuffer();
        for (String item : lst) {
            sb.append(item);
            sb.append(":");
        }
        return sb.toString();
    }

    public void selectOptions(List<String> ids) {
        String newSelectionDigest = this.getSelectionDigest(ids);
        if (this.lastSelectionDigest != null && this.lastSelectionDigest.equals(newSelectionDigest)) {
            return;
        }
        this.getPackageOptions().select(ids);
        this.downloadStarted = false;
        this.lastSelectionDigest = newSelectionDigest;
    }

    protected File getDownloadDirectory() {
        File mpDir = this.getConfig().getDistributionMPDir();
        if (!mpDir.exists()) {
            mpDir.mkdirs();
        }
        return mpDir;
    }

    public boolean canReachServer() {
        if (this.canReachServer == null) {
            HttpGet ping = new HttpGet(this.getBaseUrl() + "packages.xml");
            try {
                HttpResponse response = this.httpClient.execute((HttpUriRequest)ping);
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.canReachServer = true;
                } else {
                    log.info((Object)("Unable to ping server -> status code :" + response.getStatusLine().getStatusCode() + " (" + response.getStatusLine().getReasonPhrase() + ")"));
                    this.canReachServer = false;
                }
            }
            catch (Exception e) {
                log.info((Object)("Unable to ping remote server " + e.getMessage()));
                log.debug((Object)"Unable to ping remote server", (Throwable)e);
                this.canReachServer = false;
            }
        }
        return this.canReachServer;
    }

    public DownloadablePackageOptions getPackageOptions() {
        block11: {
            if (this.downloadOptions == null) {
                File packageFile = null;
                if (this.canReachServer()) {
                    packageFile = this.getRemotePackagesDescriptor();
                }
                if (packageFile == null) {
                    packageFile = this.getLocalPackagesDescriptor();
                    if (packageFile == null) {
                        log.warn((Object)"Unable to find local copy of packages.xml");
                    } else {
                        log.info((Object)"Wizard will use the local copy of packages.xml.");
                    }
                }
                if (packageFile != null) {
                    try {
                        this.downloadOptions = DownloadDescriptorParser.parsePackages((InputStream)new FileInputStream(packageFile));
                        Properties defaultSelection = this.getDefaultPackageSelection();
                        if (defaultSelection == null) break block11;
                        String presetId = defaultSelection.getProperty("preset", null);
                        if (presetId != null && !presetId.isEmpty()) {
                            for (Preset preset : this.downloadOptions.getPresets()) {
                                if (!preset.getId().equals(presetId)) continue;
                                List<String> pkgIds = Arrays.asList(preset.getPkgs());
                                this.downloadOptions.select(pkgIds);
                                break block11;
                            }
                            break block11;
                        }
                        String pkgIdsList = defaultSelection.getProperty("packages", null);
                        if (pkgIdsList != null && !pkgIdsList.isEmpty()) {
                            String[] ids = pkgIdsList.split(",");
                            List<String> pkgIds = Arrays.asList(ids);
                            this.downloadOptions.select(pkgIds);
                        }
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Unable to read packages.xml", (Throwable)e);
                    }
                }
            }
        }
        return this.downloadOptions;
    }

    protected File getRemotePackagesDescriptor() {
        File desc = null;
        HttpGet ping = new HttpGet(this.getBaseUrl() + "packages.xml");
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)ping);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.warn((Object)("Unable to download remote packages.xml, status code :" + response.getStatusLine().getStatusCode() + " (" + response.getStatusLine().getReasonPhrase() + ")"));
                return null;
            }
            desc = new File(this.getDownloadDirectory(), "packages.xml");
            FileUtils.copyToFile((InputStream)response.getEntity().getContent(), (File)desc);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to reach remote packages.xml", (Throwable)e);
            return null;
        }
        return desc;
    }

    protected Properties getDefaultPackageSelection() {
        File desc = new File(this.getDownloadDirectory(), "packages-default-selection.properties");
        if (desc.exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileReader(desc));
                return props;
            }
            catch (IOException e) {
                log.warn((Object)"Unable to load presets", (Throwable)e);
            }
        }
        return null;
    }

    protected void saveSelectedPackages(List<DownloadPackage> pkgs) {
        File desc = new File(this.getDownloadDirectory(), "packages-default-selection.properties");
        Properties props = new Properties();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pkgs.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(pkgs.get(i).getId());
        }
        props.put("packages", sb.toString());
        try {
            props.store(new FileWriter(desc), "Saved from Nuxeo SetupWizard");
        }
        catch (IOException e) {
            log.error((Object)"Unable to save package selection", (Throwable)e);
        }
    }

    protected File getLocalPackagesDescriptor() {
        File desc = new File(this.getDownloadDirectory(), "packages.xml");
        if (desc.exists()) {
            return desc;
        }
        return null;
    }

    public List<DownloadPackage> getSelectedPackages() {
        List pkgs = this.getPackageOptions().getPkg4Download();
        for (DownloadPackage pkg : pkgs) {
            if (this.needToDownload(pkg)) {
                pkg.setAlreadyInLocal(false);
                continue;
            }
            pkg.setAlreadyInLocal(true);
        }
        return pkgs;
    }

    public void scheduleDownloadedPackagesForInstallation(String installationFilePath) throws IOException {
        ArrayList<String> fileEntries = new ArrayList<String>();
        fileEntries.add("init");
        List pkgs = this.downloadOptions.getPkg4Download();
        ArrayList<String> pkgInstallIds = new ArrayList<String>();
        for (DownloadPackage pkg : pkgs) {
            if (pkg.isAlreadyInLocal()) {
                fileEntries.add("install " + pkg.getId());
                pkgInstallIds.add(pkg.getId());
                continue;
            }
            for (PendingDownload download : this.pendingDownloads) {
                if (!download.getPkg().equals((Object)pkg)) continue;
                if (download.getStatus() == 4) {
                    File file = download.getDowloadingFile();
                    fileEntries.add("add file:" + file.getAbsolutePath());
                    fileEntries.add("install " + pkg.getId());
                    pkgInstallIds.add(pkg.getId());
                    continue;
                }
                log.error((Object)("One selected package has not been downloaded : " + pkg.getId()));
            }
        }
        File installLog = new File(installationFilePath);
        if (fileEntries.size() > 0) {
            if (!installLog.exists()) {
                File parent = installLog.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                installLog.createNewFile();
            }
            FileUtils.writeLines((File)installLog, fileEntries);
        } else if (installLog.exists()) {
            installLog.delete();
        }
        this.saveSelectedPackages(pkgs);
    }

    public List<PendingDownload> getPendingDownloads() {
        return this.pendingDownloads;
    }

    public void reStartDownload(String id) {
        for (PendingDownload pending : this.pendingDownloads) {
            if (!pending.getPkg().getId().equals(id)) continue;
            if (!Arrays.asList(-3, -1).contains(pending.getStatus())) break;
            this.pendingDownloads.remove(pending);
            this.startDownloadPackage(pending.getPkg());
            break;
        }
    }

    public void startDownload() {
        this.startDownload(this.downloadOptions.getPkg4Download());
    }

    public void startDownload(List<DownloadPackage> pkgs) {
        this.downloadStarted = true;
        for (DownloadPackage pkg : pkgs) {
            if (!this.needToDownload(pkg)) continue;
            this.startDownloadPackage(pkg);
        }
    }

    protected boolean needToDownload(DownloadPackage pkg) {
        for (File file : this.getDownloadDirectory().listFiles()) {
            if (!file.getName().equals(pkg.getMd5())) continue;
            pkg.setLocalFile(file);
            return false;
        }
        return true;
    }

    protected void startDownloadPackage(DownloadPackage pkg) {
        PendingDownload download = new PendingDownload(pkg);
        if (this.pendingDownloads.addIfAbsent(download)) {
            3 downloadRunner = new /* Unavailable Anonymous Inner Class!! */;
            this.download_tpe.execute((Runnable)downloadRunner);
        }
    }

    protected void checkPackage(PendingDownload download) {
        File filePkg = download.getDowloadingFile();
        4 checkRunner = new /* Unavailable Anonymous Inner Class!! */;
        this.check_tpe.execute((Runnable)checkRunner);
    }

    protected String getDigest(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[102400];
            FileInputStream stream = new FileInputStream(file);
            int bytesRead = -1;
            while ((bytesRead = ((InputStream)stream).read(buffer)) >= 0) {
                md.update(buffer, 0, bytesRead);
            }
            ((InputStream)stream).close();
            byte[] b = md.digest();
            return PackageDownloader.md5ToHex((byte[])b);
        }
        catch (Exception e) {
            log.error((Object)"Error while computing Digest ", (Throwable)e);
            return null;
        }
    }

    protected static String md5ToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public boolean isDownloadStarted() {
        return this.downloadStarted;
    }

    public boolean isDownloadCompleted() {
        if (!this.isDownloadStarted()) {
            return false;
        }
        for (PendingDownload download : this.pendingDownloads) {
            if (download.getStatus() >= 4) continue;
            return false;
        }
        return true;
    }

    public boolean isDownloadInProgress() {
        if (!this.isDownloadStarted()) {
            return false;
        }
        if (this.isDownloadCompleted()) {
            return false;
        }
        int nbInProgress = 0;
        for (PendingDownload download : this.pendingDownloads) {
            if (download.getStatus() >= 4 || download.getStatus() < 0) continue;
            ++nbInProgress;
        }
        return nbInProgress > 0;
    }

    public void shutdown() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
        this.download_tpe.shutdownNow();
        this.check_tpe.shutdownNow();
    }
}

