/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.io.File;
import org.nuxeo.wizard.download.DownloadPackage;

public class PendingDownload {
    public static final int PENDING = 0;
    public static final int INPROGRESS = 1;
    public static final int COMPLETED = 2;
    public static final int VERIFICATION = 3;
    public static final int VERIFIED = 4;
    public static final int ABORTED = -1;
    public static final int MISSING = -2;
    public static final int CORRUPTED = -3;
    protected final DownloadPackage pkg;
    protected int status = 0;
    protected float expectedLength;
    protected File dowloadingFile;

    public PendingDownload(DownloadPackage pkg) {
        this.pkg = pkg;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public DownloadPackage getPkg() {
        return this.pkg;
    }

    public int getProgress() {
        if (this.expectedLength == 0.0f || this.dowloadingFile == null || this.dowloadingFile.length() == 0L) {
            return 0;
        }
        return new Float((float)this.dowloadingFile.length() / this.expectedLength * 100.0f).intValue();
    }

    public boolean equals(Object other) {
        if (other instanceof PendingDownload) {
            return ((PendingDownload)other).getPkg().getId().equals(this.pkg.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.pkg.getId().hashCode();
    }

    public void setFile(long expectedLength, File dowloadingFile) {
        this.expectedLength = expectedLength;
        this.dowloadingFile = dowloadingFile;
    }

    public File getDowloadingFile() {
        return this.dowloadingFile;
    }
}

