/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.nav;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.wizard.context.Context;

public class Page {
    public static String NUXEO_COM_URL = "http://www.nuxeo.com/embedded/wizard/";
    protected final String action;
    protected final String jsp;
    protected int progress = -1;
    protected Page prev;
    protected Page next;
    protected boolean active = true;
    protected boolean hidden = false;
    protected boolean navigated = false;

    public Page(String pageConfigString) {
        String[] parts = pageConfigString.split("\\|");
        this.action = parts[0];
        String jspPage = parts[1];
        if (!jspPage.startsWith("/")) {
            jspPage = "/" + jspPage;
        }
        this.jsp = jspPage;
        if ("0".equals(parts[2])) {
            this.active = false;
        }
        if ("1".equals(parts[3])) {
            this.hidden = true;
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getJsp() {
        return this.jsp;
    }

    public Page prev() {
        if (this.prev.isActive()) {
            return this.prev;
        }
        return this.prev.prev();
    }

    public Page next() {
        if (this.next.isActive()) {
            return this.next;
        }
        return this.next.next();
    }

    public void dispatchToJSP(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatchToJSP(req, resp, false);
    }

    public void dispatchToJSP(HttpServletRequest req, HttpServletResponse resp, boolean postBack) throws ServletException, IOException {
        Context.instance((HttpServletRequest)req);
        req.setAttribute("currentPage", (Object)this);
        if (postBack && "POST".equals(req.getMethod())) {
            String target = "/" + req.getContextPath() + "/" + this.action;
            if (target.startsWith("//")) {
                target = target.substring(1);
            }
            resp.sendRedirect(target);
        } else {
            req.getRequestDispatcher(this.jsp).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public String toString() {
        return this.action + ":" + this.jsp;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getAssociatedIFrameUrl() {
        return NUXEO_COM_URL + this.action;
    }

    public String getLabelKey() {
        return "label.short." + this.jsp.replace(".jsp", "").substring(1);
    }

    public boolean isVisibleInNavigationMenu() {
        return this.active && !this.hidden;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean hasBeenNavigatedBefore() {
        return this.navigated;
    }
}

