/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     jcarsique
 */
package org.nuxeo.wizard.download;

public enum PendingDownloadStatus {
    CORRUPTED(-3), MISSING(-2), ABORTED(-1), PENDING(0), INPROGRESS(1), COMPLETED(2), VERIFICATION(3), VERIFIED(4);

    private final int value;

    private PendingDownloadStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }
}
