/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.context;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.wizard.context.ParamCollector;

public class Context {
    public static final String CONTEXT_ATTRIBUTE = "context";
    protected static ParamCollector collector;
    protected static String baseUrl;
    protected static Boolean browserInternetAccess;
    protected Map<String, String> errors = new HashMap();
    protected Map<String, String> infos = new HashMap();
    protected static Map<String, String> connectMap;
    protected static String distributionKey;
    protected HttpServletRequest req;

    protected Context(HttpServletRequest req) {
        this.req = req;
    }

    public static Context instance(HttpServletRequest req) {
        Context ctx = (Context)req.getAttribute(CONTEXT_ATTRIBUTE);
        if (ctx == null) {
            ctx = new Context(req);
            req.setAttribute(CONTEXT_ATTRIBUTE, (Object)ctx);
        }
        return ctx;
    }

    public static void reset() {
        collector = null;
        connectMap = null;
    }

    public ParamCollector getCollector() {
        if (collector == null) {
            collector = new ParamCollector();
        }
        return collector;
    }

    public String getDistributionKey() {
        if (distributionKey == null) {
            ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
            configurationGenerator.init();
            try {
                Properties distribution = new Properties();
                distribution.load(new FileInputStream(new File(configurationGenerator.getConfigDir(), "distribution.properties")));
                String name = distribution.getProperty("org.nuxeo.distribution.name", "unknown").toLowerCase();
                String server = distribution.getProperty("org.nuxeo.distribution.server", "unknown").toLowerCase();
                String version = distribution.getProperty("org.nuxeo.distribution.version", "unknown").toLowerCase();
                String pkg = distribution.getProperty("org.nuxeo.distribution.package", "unknown").toLowerCase();
                distributionKey = name + "-" + server + "-" + version + "-" + pkg;
            }
            catch (Exception e) {
                distributionKey = "unknown";
            }
        }
        return distributionKey;
    }

    public void trackError(String fieldId, String message) {
        this.errors.put(fieldId, message);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void trackInfo(String fieldId, String message) {
        this.infos.put(fieldId, message);
    }

    public boolean hasInfos() {
        return this.infos.size() > 0;
    }

    public Map<String, String> getErrorsMap() {
        return this.errors;
    }

    public Map<String, String> getInfosMap() {
        return this.infos;
    }

    public String getFieldsInErrorAsJson() {
        StringBuffer sb = new StringBuffer("[");
        for (String key : this.errors.keySet()) {
            sb.append("'");
            sb.append(key);
            sb.append("',");
        }
        sb.append("END]");
        return sb.toString().replace(",END", "");
    }

    public void storeConnectMap(Map<String, String> map) {
        connectMap = map;
    }

    public boolean isConnectRegistrationDone() {
        return connectMap != null && "true".equals(connectMap.get("registrationOK"));
    }

    public static Map<String, String> getConnectMap() {
        return connectMap;
    }

    public void setBaseUrl(String base) {
        baseUrl = base;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public boolean isBrowserInternetAccessChecked() {
        return browserInternetAccess != null;
    }

    public boolean hasBrowserInternetAccess() {
        if (browserInternetAccess == null) {
            return false;
        }
        return browserInternetAccess;
    }

    public void setBrowserInternetAccess(boolean browserInternetAccess) {
        Context.browserInternetAccess = browserInternetAccess;
    }

    static {
        distributionKey = null;
    }
}

