/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DownloadPackage {
    protected String baseUrl;
    protected String filename;
    protected String label;
    protected String md5;
    protected boolean virtual;
    protected File localFile;
    protected String color;
    protected String textColor;
    protected boolean enabled;
    protected final String id;
    protected String downloadUrl;
    protected String shortLabel;
    protected String description;
    protected final List<String> impliedDeps = new ArrayList();

    public DownloadPackage(String id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        if ("".equals(md5)) {
            md5 = null;
        }
        this.md5 = md5;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public String getId() {
        return this.id;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        if (baseUrl != null && !baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DownloadPackage) {
            return ((DownloadPackage)obj).id.equals(this.id);
        }
        return super.equals(obj);
    }

    public String getDownloadUrl() {
        if (this.downloadUrl != null) {
            return this.downloadUrl;
        }
        return this.getBaseUrl() + this.getFilename();
    }

    public void setDownloadUrl(String url) {
        this.downloadUrl = url;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.id);
        sb.append(" (");
        sb.append(this.label);
        sb.append(" )]");
        return sb.toString();
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean isAlreadyInLocal() {
        return this.getLocalFile() != null && this.getLocalFile().exists();
    }

    public List<String> getImpliedDeps() {
        return this.impliedDeps;
    }

    public void addDep(String depId) {
        this.impliedDeps.add(depId);
    }

    public void addDeps(String[] depIds) {
        for (String depId : depIds) {
            this.addDep(depId);
        }
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isLaterDownload() {
        return StringUtils.isBlank((CharSequence)this.getDownloadUrl()) || StringUtils.isEmpty((CharSequence)this.getFilename());
    }
}

