/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.wizard.download.DownloadPackage;

public class DownloadablePackageOption {
    protected final DownloadPackage pkg;
    protected boolean exclusive;
    protected boolean selected = false;
    protected String label;
    protected List<DownloadablePackageOption> childrenPackages = new ArrayList();
    protected final String id;
    protected DownloadablePackageOption parent;

    public DownloadablePackageOption(DownloadPackage pkg, int idx) {
        this.pkg = pkg;
        this.id = "o" + idx;
    }

    public DownloadablePackageOption(DownloadPackage pkg, String id) {
        this.pkg = pkg;
        this.id = id;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setExclusive(String exclusive) {
        if (exclusive != null) {
            this.exclusive = "true".equalsIgnoreCase(exclusive);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public List<DownloadablePackageOption> getChildrenPackages() {
        return this.childrenPackages;
    }

    public void addChildPackage(DownloadablePackageOption child) {
        this.childrenPackages.add(child);
        child.setParent(this);
    }

    protected void setParent(DownloadablePackageOption parent) {
        this.parent = parent;
    }

    public List<DownloadablePackageOption> getSiblingPackages() {
        ArrayList<DownloadablePackageOption> siblings = new ArrayList<DownloadablePackageOption>();
        if (this.parent != null) {
            for (DownloadablePackageOption sibling : this.parent.getChildrenPackages()) {
                if (sibling.getId() == this.getId()) continue;
                siblings.add(sibling);
            }
        }
        return siblings;
    }

    public String getLabel() {
        if (this.label == null && this.pkg != null) {
            return this.pkg.getLabel();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public DownloadPackage getPackage() {
        return this.pkg;
    }

    public String getId() {
        return this.id;
    }

    public String getColor() {
        if (this.pkg != null) {
            return this.pkg.getColor();
        }
        return "";
    }

    public String getDescription() {
        if (this.pkg != null) {
            return this.pkg.getDescription();
        }
        return "";
    }

    public boolean isVirtual() {
        if (this.pkg != null) {
            return this.pkg.isVirtual();
        }
        return false;
    }

    public String getTextColor() {
        if (this.pkg != null) {
            return this.pkg.getTextColor();
        }
        return "";
    }

    public DownloadablePackageOption getParent() {
        return this.parent;
    }

    public String getShortLabel() {
        if (this.pkg != null) {
            return this.pkg.getShortLabel();
        }
        return null;
    }
}

