/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.onedrive.OneDriveBlobProvider;
import org.nuxeo.ecm.liveconnect.onedrive.OneDriveOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.runtime.api.Framework;

public class OneDriveBlobUploader
implements JSFBlobUploader {
    public static final String UPLOAD_ONEDRIVE_FACET_NAME = "uploadOneDrive";
    protected final String id;

    public OneDriveBlobUploader(String id) {
        this.id = id;
        try {
            this.getOneDriveBlobProvider();
        }
        catch (NuxeoException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getChoice() {
        return UPLOAD_ONEDRIVE_FACET_NAME;
    }

    public void hookSubComponent(UIInput parent) {
        Application app = FacesContext.getCurrentInstance().getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)parent, (String)UPLOAD_ONEDRIVE_FACET_NAME, (UIComponent)app.createComponent("javax.faces.HtmlInputText"));
    }

    public void encodeBeginUpload(UIInput parent, FacesContext context, String onClick) throws IOException {
        UIComponent facet = parent.getFacet(UPLOAD_ONEDRIVE_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        ResponseWriter writer = context.getResponseWriter();
        OneDriveBlobProvider blobProvider = this.getOneDriveBlobProvider();
        OneDriveOAuth2ServiceProvider oauthProvider = (OneDriveOAuth2ServiceProvider)blobProvider.getOAuth2Provider();
        String inputId = facet.getClientId(context);
        String prefix = parent.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        String pickId = prefix + "OneDrivePickMsg";
        String infoId = prefix + "OneDriveInfo";
        Locale locale = context.getViewRoot().getLocale();
        boolean isProviderAvailable = oauthProvider != null && oauthProvider.isProviderAvailable();
        writer.startElement("button", (UIComponent)parent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"button", null);
        if (isProviderAvailable) {
            String accessToken = this.getCurrentUserAccessToken(blobProvider);
            String authorizationUrl = this.getOAuthAuthorizationUrl(oauthProvider);
            String baseUrl = ((OneDriveAPI)oauthProvider.getAPIInitializer().apply("")).getBaseURL();
            String onButtonClick = onClick + ";" + String.format("new nuxeo.utils.OneDrivePicker('%s', '%s','%s', '%s', '%s', '%s')", this.getClientId(oauthProvider), inputId, infoId, accessToken, authorizationUrl, baseUrl);
            writer.writeAttribute("onclick", (Object)onButtonClick, null);
        }
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)pickId, null);
        String message = I18NUtils.getMessageString((String)"messages", (String)"label.inputFile.oneDriveUploadPicker", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        writer.endElement("button");
        if (isProviderAvailable) {
            writer.write("&#x0020;");
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("id", (Object)infoId, null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.inputFile.noFileSelected", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        } else {
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("class", (Object)"processMessage completeWarning", null);
            writer.writeAttribute("style", (Object)"margin: 0 0 .5em 0; font-size: 11px; padding: 0.4em 0.5em 0.5em 2.2em; background-position-y: 0.6em", null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.oneDrive.providerUnavailable", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        }
        inputText.setLocalValueSet(false);
        inputText.setStyle("display: none");
        ComponentUtils.encodeComponent((FacesContext)context, (UIComponent)inputText);
    }

    public void validateUpload(UIInput parent, FacesContext context, InputFileInfo submitted) {
        UIComponent facet = parent.getFacet(UPLOAD_ONEDRIVE_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        Object value = inputText.getSubmittedValue();
        if (value != null && !(value instanceof String)) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidSpecialBlob");
            parent.setValid(false);
            return;
        }
        String fileId = (String)value;
        if (StringUtils.isBlank((CharSequence)fileId)) {
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)message);
            parent.setValid(false);
            return;
        }
        OneDriveBlobProvider blobProvider = this.getOneDriveBlobProvider();
        OneDriveOAuth2ServiceProvider oauthProvider = (OneDriveOAuth2ServiceProvider)blobProvider.getOAuth2Provider();
        if (oauthProvider == null) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.oneDriveInvalidConfiguration");
            parent.setValid(false);
            return;
        }
        Optional<NuxeoOAuth2Token> nuxeoToken = this.getCurrentNuxeoToken(blobProvider);
        if (!nuxeoToken.isPresent()) {
            String link = String.format("<a href='#' onclick=\"openPopup('%s'); return false;\">Register a new token</a> and try again.", this.getOAuthAuthorizationUrl(oauthProvider));
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.oneDriveInvalidPermissions", (Object[])new Object[]{link});
            parent.setValid(false);
            return;
        }
        try {
            LiveConnectFileInfo fileInfo = new LiveConnectFileInfo(nuxeoToken.get().getServiceLogin(), fileId);
            SimpleManagedBlob blob = blobProvider.toBlob(fileInfo);
            submitted.setBlob((Blob)blob);
            submitted.setFilename((Object)blob.getFilename());
            submitted.setMimeType((Object)blob.getMimeType());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnabled() {
        OneDriveOAuth2ServiceProvider provider = (OneDriveOAuth2ServiceProvider)this.getOneDriveBlobProvider().getOAuth2Provider();
        return provider != null && provider.isEnabled();
    }

    protected String getClientId(OneDriveOAuth2ServiceProvider provider) {
        return Optional.ofNullable(provider).map(NuxeoOAuth2ServiceProvider::getClientId).orElse("");
    }

    protected OneDriveBlobProvider getOneDriveBlobProvider() {
        return (OneDriveBlobProvider)((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.id);
    }

    private String getCurrentUserAccessToken(OneDriveBlobProvider provider) throws IOException {
        Credential credential;
        Long expiresInSeconds;
        Optional<NuxeoOAuth2Token> nuxeoToken = this.getCurrentNuxeoToken(provider);
        if (nuxeoToken.isPresent() && (expiresInSeconds = (credential = provider.getCredential(nuxeoToken.get().getServiceLogin())).getExpiresInSeconds()) != null && expiresInSeconds > 0L) {
            return credential.getAccessToken();
        }
        return "";
    }

    private Optional<NuxeoOAuth2Token> getCurrentNuxeoToken(OneDriveBlobProvider provider) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("nuxeoLogin", FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal().getName());
        return ((OneDriveOAuth2ServiceProvider)provider.getOAuth2Provider()).getCredentialDataStore().query(filter).stream().map(NuxeoOAuth2Token::new).findFirst();
    }

    private String getOAuthAuthorizationUrl(OneDriveOAuth2ServiceProvider provider) {
        HttpServletRequest request = this.getHttpServletRequest();
        return provider != null && provider.getClientId() != null ? provider.getAuthorizationUrl(request) : "";
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }
}

