/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.diff.model.DiffComplexFieldDefinition;
import org.nuxeo.ecm.diff.model.DiffFieldItemDefinition;

public class DiffComplexFieldDefinitionImpl
implements DiffComplexFieldDefinition {
    private static final long serialVersionUID = 5289865501066754428L;
    protected String schema;
    protected String name;
    protected List<DiffFieldItemDefinition> includedItems;
    protected List<DiffFieldItemDefinition> excludedItems;

    public DiffComplexFieldDefinitionImpl(String schema, String name) {
        this(schema, name, new ArrayList<DiffFieldItemDefinition>(), new ArrayList<DiffFieldItemDefinition>());
    }

    public DiffComplexFieldDefinitionImpl(String schema, String name, List<DiffFieldItemDefinition> includedItems, List<DiffFieldItemDefinition> excludedItems) {
        this.schema = schema;
        this.name = name;
        this.includedItems = includedItems;
        this.excludedItems = excludedItems;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DiffFieldItemDefinition> getIncludedItems() {
        return this.includedItems;
    }

    @Override
    public List<DiffFieldItemDefinition> getExcludedItems() {
        return this.excludedItems;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DiffComplexFieldDefinition)) {
            return false;
        }
        String otherSchema = ((DiffComplexFieldDefinition)other).getSchema();
        String otherName = ((DiffComplexFieldDefinition)other).getName();
        if (this.schema == null && otherSchema == null && this.name == null && otherName == null) {
            return true;
        }
        if (this.schema == null || otherSchema == null || this.name == null || otherName == null || this.schema != null && !this.schema.equals(otherSchema) || this.name != null && !this.name.equals(otherName)) {
            return false;
        }
        List<DiffFieldItemDefinition> otherIncludedItems = ((DiffComplexFieldDefinition)other).getIncludedItems();
        List<DiffFieldItemDefinition> otherExcludedItems = ((DiffComplexFieldDefinition)other).getExcludedItems();
        if (CollectionUtils.isEmpty(this.includedItems) && CollectionUtils.isEmpty(otherIncludedItems) && CollectionUtils.isEmpty(this.excludedItems) && CollectionUtils.isEmpty(otherExcludedItems)) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.includedItems) && !CollectionUtils.isEmpty(otherIncludedItems) || !CollectionUtils.isEmpty(this.includedItems) && CollectionUtils.isEmpty(otherIncludedItems) || !((Object)this.includedItems).equals(otherIncludedItems)) {
            return false;
        }
        return !(CollectionUtils.isEmpty(this.excludedItems) && !CollectionUtils.isEmpty(otherExcludedItems) || !CollectionUtils.isEmpty(this.excludedItems) && CollectionUtils.isEmpty(otherExcludedItems)) && ((Object)this.excludedItems).equals(otherExcludedItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.schema);
        sb.append(":");
        sb.append(this.name);
        sb.append(!CollectionUtils.isEmpty(this.includedItems) ? " / " + this.includedItems : "");
        sb.append(!CollectionUtils.isEmpty(this.excludedItems) ? " / " + this.excludedItems : "");
        return sb.toString();
    }
}

