/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.diff.model.DiffBlockDefinition;
import org.nuxeo.ecm.diff.model.DiffFieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;

public class DiffBlockDefinitionImpl
implements DiffBlockDefinition {
    private static final long serialVersionUID = 511776842683091931L;
    protected String name;
    protected Map<String, String> templates;
    protected List<DiffFieldDefinition> fields;
    protected Map<String, Map<String, Serializable>> properties;

    public DiffBlockDefinitionImpl(String name, Map<String, String> templates, List<DiffFieldDefinition> fields, Map<String, Map<String, Serializable>> properties) {
        this.name = name;
        this.templates = templates;
        this.fields = fields == null ? new ArrayList<DiffFieldDefinition>() : fields;
        this.properties = properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTemplate(String mode) {
        if (this.templates != null) {
            String template = this.templates.get(mode);
            if (template == null) {
                template = this.templates.get("any");
            }
            return template;
        }
        return null;
    }

    @Override
    public Map<String, String> getTemplates() {
        return this.templates;
    }

    @Override
    public List<DiffFieldDefinition> getFields() {
        return this.fields;
    }

    @Override
    public Map<String, Serializable> getProperties(String layoutMode) {
        return WidgetDefinitionImpl.getProperties(this.properties, (String)layoutMode);
    }

    @Override
    public Map<String, Map<String, Serializable>> getProperties() {
        return this.properties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DiffBlockDefinition)) {
            return false;
        }
        String otherName = ((DiffBlockDefinition)other).getName();
        if (this.name == null && otherName == null) {
            return true;
        }
        if (this.name == null && otherName != null || this.name != null && otherName == null || !this.name.equals(otherName)) {
            return false;
        }
        Map<String, String> otherTemplates = ((DiffBlockDefinition)other).getTemplates();
        List<DiffFieldDefinition> otherFields = ((DiffBlockDefinition)other).getFields();
        Map<String, Map<String, Serializable>> otherProperties = ((DiffBlockDefinition)other).getProperties();
        if (MapUtils.isEmpty(this.templates) && MapUtils.isEmpty(otherTemplates) && CollectionUtils.isEmpty(this.fields) && CollectionUtils.isEmpty(otherFields) && MapUtils.isEmpty(this.properties) && MapUtils.isEmpty(otherProperties)) {
            return true;
        }
        return !(MapUtils.isEmpty(this.templates) && !MapUtils.isEmpty(otherTemplates) || !MapUtils.isEmpty(this.templates) && MapUtils.isEmpty(otherTemplates) || this.templates != null && !((Object)this.templates).equals(otherTemplates) || CollectionUtils.isEmpty(this.fields) && !CollectionUtils.isEmpty(otherFields) || !CollectionUtils.isEmpty(this.fields) && CollectionUtils.isEmpty(otherFields) || this.fields != null && !((Object)this.fields).equals(otherFields) || MapUtils.isEmpty(this.properties) && !MapUtils.isEmpty(otherProperties) || !MapUtils.isEmpty(this.properties) && MapUtils.isEmpty(otherProperties)) && (this.properties == null || ((Object)this.properties).equals(otherProperties));
    }

    public String toString() {
        return this.name + this.fields + this.templates + this.properties;
    }
}

