/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.permission.adapter.UserSyncRootParentFolderItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserSyncRootParentFactory
extends AbstractFileSystemItemFactory
implements VirtualFolderItemFactory {
    private static final Log log = LogFactory.getLog(UserSyncRootParentFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected String folderName;

    public void handleParameters(Map<String, String> parameters) throws ClientException {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (StringUtils.isEmpty((String)folderNameParam)) {
            throw new ClientException(String.format("Factory %s has no %s parameter, please provide one.", this.getName(), FOLDER_NAME_PARAM));
        }
        this.folderName = folderNameParam;
    }

    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        boolean isUserWorkspace = UserWorkspaceHelper.isUserWorkspace((DocumentModel)doc);
        if (!isUserWorkspace) {
            log.trace((Object)String.format("Document %s is not a user workspace, it cannot be adapted as a FileSystemItem.", doc.getId()));
            return false;
        }
        if (!includeDeleted && "deleted".equals(doc.getCurrentLifeCycleState())) {
            log.debug((Object)String.format("Document %s is in the '%s' life cycle state, it cannot be adapted as a FileSystemItem.", doc.getId(), "deleted"));
            return false;
        }
        return true;
    }

    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem) throws ClientException {
        return new UserSyncRootParentFolderItem(this.getName(), doc, parentItem, this.folderName);
    }

    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) throws ClientException {
        Principal principal = doc.getCoreSession().getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted);
    }

    public FolderItem getVirtualFolderItem(Principal principal) throws ClientException {
        DocumentModel userWorkspace = this.getUserPersonalWorkspace(principal);
        return (FolderItem)this.getFileSystemItem(userWorkspace);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    protected FolderItem getTopLevelFolderItem(Principal principal) throws ClientException {
        FolderItem topLevelFolder = this.getFileSystemItemManager().getTopLevelFolder(principal);
        if (topLevelFolder == null) {
            throw new ClientException("Found no top level folder item. Please check your contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"topLevelFolderItemFactory\">.");
        }
        return topLevelFolder;
    }

    protected DocumentModel getUserPersonalWorkspace(Principal principal) throws ClientException {
        RepositoryManager repositoryManager;
        CoreSession session;
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session = this.getSession((repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class)).getDefaultRepository().getName(), principal), null);
        if (userWorkspace == null) {
            throw new ClientException(String.format("No personal workspace found for user %s.", principal.getName()));
        }
        return userWorkspace;
    }

    protected FileSystemItemManager getFileSystemItemManager() {
        return (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
    }

    protected CoreSession getSession(String repositoryName, Principal principal) throws ClientException {
        return this.getFileSystemItemManager().getSession(repositoryName, principal);
    }
}

