/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.factory.PreferenceManager;
import org.nuxeo.opensocial.container.utils.SecureTokenBuilder;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private static final String SERVLET_PATH = "opensocial/gadgets/ifr";
    private static final String CONTAINER_KEY = "container";
    private static final String CONTAINER_VALUE = "default";
    private static final String GADGET_ID_KEY = "mid";
    private static final String NOCACHE_KEY = "nocache";
    private static final String NOCACHE_VALUE = "1";
    private static final String COUNTRY_KEY = "country";
    private static final String COUNTRY_VALUE = "ALL";
    private static final String LANG_KEY = "lang";
    private static final String VIEW_KEY = "view";
    private static final String VIEW_VALUE = "default";
    private static final String PERMISSION_KEY = "permission";
    private static final String URL_KEY = "url";
    private static final String PREF_PREFIX = "up_";
    private static final String SECURITY_TOKEN_KEY = "st";
    private static final String RPC_TOKEN = "rpctoken";
    private static final Log log = LogFactory.getLog(UrlBuilder.class);
    private static final String PARENT_KEY = "parent";
    private static final boolean SHINDIG_DEBUG = "true".equals(Framework.getProperty((String)"shindig.gadget.debug"));
    private static int containerId = 0;

    public static String buildShindigUrl(Gadget gadget, String serverBase, List<String> permissions, String locale) throws ClientException {
        String gadgetDef = gadget.getDefinitionUrl().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(serverBase + SERVLET_PATH + "?");
        sb.append(UrlBuilder.getDefaultParams(locale) + "&");
        sb.append("mid=" + containerId++ + "&");
        sb.append("parent=" + serverBase + "&");
        sb.append("permission=" + permissions + "&");
        sb.append("url=" + gadgetDef + UrlBuilder.getUserPrefs(PreferenceManager.getPreferences(gadget)) + "&");
        sb.append(PREF_PREFIX + gadget.getHeight() + "&");
        if (SHINDIG_DEBUG) {
            sb.append("debug=1&");
        } else {
            sb.append("debug=0&");
        }
        try {
            sb.append("st=" + UrlBuilder.getSecurityToken(gadget, gadgetDef));
        }
        catch (Exception e) {
            throw new ClientException("Unable to getSecurity Token", (Throwable)e);
        }
        sb.append("&rpctoken=" + gadget.getId());
        return sb.toString();
    }

    public static String getGadgetDef(String name) throws Exception {
        return ((GadgetService)Framework.getService(GadgetService.class)).getGadgetDefinition(name).toString();
    }

    private static String getSecurityToken(Gadget gadget, String url) throws Exception {
        return SecureTokenBuilder.getSecureToken((String)gadget.getViewer(), (String)gadget.getOwner(), (String)url);
    }

    protected static String getUserPrefs(List<PreferencesBean> prefs) {
        String prefsParams = "";
        for (PreferencesBean bean : prefs) {
            String value = bean.getDefaultValue();
            if (bean.getValue() != null) {
                value = bean.getValue();
            }
            try {
                prefsParams = prefsParams + "&up_" + bean.getName() + "=" + URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        return prefsParams;
    }

    private static String getDefaultParams(String locale) {
        return "container=default&nocache=1&country=ALL&lang=" + locale + "&" + VIEW_KEY + "=" + "default";
    }
}

