/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.nuxeo.opensocial.container.factory.PreferenceManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DefaultPreference {
    private static List<UserPref> defaultPreferences = null;
    private static final String NAME = "default-preferences.xml";

    DefaultPreference() {
    }

    static List<UserPref> getPreferences() {
        if (defaultPreferences == null) {
            try {
                DefaultPreference.loadAndParse();
            }
            catch (Exception e) {
                PreferenceManager.log.error((Object)e);
            }
        }
        return defaultPreferences;
    }

    private static void loadAndParse() throws SpecParserException, IOException {
        Element doc;
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(NAME)));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        try {
            doc = XmlUtil.parse((String)sb.toString());
        }
        catch (XmlException e) {
            throw new SpecParserException("Malformed XML in file default-preferences.xml", e);
        }
        NodeList children = doc.getChildNodes();
        LinkedList userPrefs = Lists.newLinkedList();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element element;
            Node child = children.item(i);
            if (!(child instanceof Element) || !"UserPref".equals((element = (Element)child).getTagName())) continue;
            UserPref pref = new UserPref(element);
            userPrefs.add(pref);
        }
        defaultPreferences = userPrefs;
    }
}

