/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.opensocial.container.client.bean.Container;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.factory.GadgetFactory;
import org.nuxeo.opensocial.container.factory.api.ContainerManager;
import org.nuxeo.opensocial.container.factory.utils.CoreSessionHelper;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

public class ContainerManagerImpl
implements ContainerManager {
    private static final Log log = LogFactory.getLog(ContainerManagerImpl.class);
    public static final String DOC_REF = "docRef";
    public static final String REPO_NAME = "repoName";
    public static final String RESET_GADGET_TITLE = "resetGadgetTitle";
    public static final String USER_LANGUAGE = "userLanguage";
    private static final String LAYOUT_PREFIX = "x-";
    private static final String LAYOUT_SEPARATOR = "-";
    public static final int DEFAULT_STRUCTURE = 3;
    public static final String DEFAULT_LAYOUT = "x-3-default";
    private static final Object NX_BASE_URL = "nxBaseUrl";

    protected SpaceManager spaceManager() throws Exception {
        return (SpaceManager)Framework.getService(SpaceManager.class);
    }

    public Container createContainer(Map<String, String> containerParams) throws ClientException {
        try {
            String spaceId = this.getParamValue(DOC_REF, containerParams, true, null);
            Space space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(containerParams));
            return this.createContainer(space, ContainerManagerImpl.getLocale(containerParams), this.getServerBase(containerParams), containerParams.get(USER_LANGUAGE));
        }
        catch (Exception e) {
            throw new ClientException("Space not found");
        }
    }

    protected static String getLocale(Map<String, String> params) {
        if (params.containsKey("locale")) {
            return params.get("locale");
        }
        return "ALL";
    }

    private String getParamValue(String key, Map<String, String> containerParams, boolean required, String defaultValue) {
        String value = containerParams.get(key);
        String retour = null;
        if (value == null) {
            if (required) {
                throw new RuntimeException("Container param for key '" + key + "' is required");
            }
            retour = defaultValue;
        } else {
            retour = value;
        }
        return retour;
    }

    private int getStructure(Space space) throws ClientException {
        int structure = 3;
        if (space.getLayout() != null) {
            try {
                StringTokenizer st = new StringTokenizer(space.getLayout(), LAYOUT_SEPARATOR);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    structure = Integer.parseInt(st.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return structure;
    }

    public GadgetBean addGadget(String gadgetName, Map<String, String> gwtParams) throws Exception {
        Space space;
        String spaceId = this.getParamValue(DOC_REF, gwtParams, true, null);
        try {
            space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(gwtParams));
        }
        catch (Exception e) {
            throw new ClientException("Space not found");
        }
        Gadget createGadget = space.createGadget(gadgetName);
        space.save();
        if (createGadget == null) {
            return null;
        }
        GadgetBean gadgetBean = GadgetFactory.getGadgetBean(createGadget, ContainerManagerImpl.getLocale(gwtParams), this.getServerBase(gwtParams));
        if (!gwtParams.containsKey(RESET_GADGET_TITLE) || "true".equalsIgnoreCase(gwtParams.get(RESET_GADGET_TITLE))) {
            gadgetBean.setTitle("");
        } else {
            this.internationalizeGadgetTitle(gadgetBean, gwtParams.get(USER_LANGUAGE));
        }
        return gadgetBean;
    }

    private String getServerBase(Map<String, String> gwtParams) {
        return gwtParams.get(NX_BASE_URL);
    }

    public Map<String, ArrayList<String>> getGadgetList() throws ClientException {
        try {
            return ((GadgetService)Framework.getService(GadgetService.class)).getGadgetNameByCategory();
        }
        catch (Exception e) {
            throw new ClientException();
        }
    }

    protected CoreSession getCoreSession(Map<String, String> gwtParams) throws Exception {
        return CoreSessionHelper.getCoreSession(gwtParams.get(REPO_NAME));
    }

    public Container saveLayout(Map<String, String> containerParams, String layout) throws ClientException {
        Space space;
        String spaceId = this.getParamValue(DOC_REF, containerParams, true, null);
        try {
            space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(containerParams));
        }
        catch (Exception e) {
            throw new ClientException("Space not found");
        }
        space.setLayout(layout);
        space.save();
        return this.createContainer(space, ContainerManagerImpl.getLocale(containerParams), this.getServerBase(containerParams), containerParams.get(USER_LANGUAGE));
    }

    private Container createContainer(Space space, String locale, String serverBase, String userLanguage) {
        try {
            if (space != null) {
                ArrayList<GadgetBean> gadgets = new ArrayList<GadgetBean>();
                for (Gadget g : space.getGadgets()) {
                    GadgetBean gadgetBean = GadgetFactory.getGadgetBean(g, locale, serverBase);
                    this.internationalizeGadgetTitle(gadgetBean, userLanguage);
                    gadgets.add(gadgetBean);
                }
                Collections.sort(gadgets);
                String layout = space.getLayout();
                if (layout == null || layout.equals("")) {
                    layout = DEFAULT_LAYOUT;
                }
                return new Container(gadgets, this.getStructure(space), layout, space.getId());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to create container", (Throwable)e);
        }
        return null;
    }

    protected void internationalizeGadgetTitle(GadgetBean gadgetBean, String userLanguage) {
        Locale locale = userLanguage != null ? new Locale(userLanguage) : Locale.getDefault();
        String labelKey = "label.gadget." + gadgetBean.getName();
        String i18nTitle = I18NUtils.getMessageString((String)"messages", (String)labelKey, null, (Locale)locale);
        if (!i18nTitle.equals(labelKey)) {
            gadgetBean.setTitle(i18nTitle);
        }
    }
}

