/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;
import org.nuxeo.opensocial.container.client.view.SavePreferenceAsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetService {
    private static Map<String, GadgetBean> beans = new HashMap<String, GadgetBean>();
    private static Timer saveAllGadgets;

    public static native void registerService();

    public static native void resizeIframe(int var0);

    public static void setHeight(String frameId, int height) {
        if (saveAllGadgets != null) {
            saveAllGadgets.cancel();
        }
        if (height < 10) {
            return;
        }
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        GadgetPortlet p = portal.getGadgetPortletByFrameId(frameId);
        GadgetBean bean = p.getGadgetBean();
        int test = bean.getHeight() - (height += 30);
        if (test != 0) {
            if (beans.containsKey(p.getId())) {
                beans.remove(p.getId());
            }
            p.setHeight(height);
            bean.setHeight(height);
            beans.put(p.getId(), bean);
            saveAllGadgets = new Timer(){

                public void run() {
                    ContainerEntryPoint.getService().saveGadgetsCollection(new ArrayList<GadgetBean>(beans.values()), ContainerEntryPoint.getGwtParams(), new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable arg0) {
                        }

                        public void onSuccess(Boolean arg0) {
                            beans.clear();
                        }
                    });
                }
            };
            saveAllGadgets.schedule(4000);
            portal.incrementLoading();
        }
    }

    public static native void setPref(String var0, String var1, String var2);

    public static void saveUserPref(String frameId) {
        GadgetBean bean = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean();
        ContainerEntryPoint.getService().saveGadgetPreferences(bean, null, ContainerEntryPoint.getGwtParams(), new SavePreferenceAsyncCallback(bean));
    }

    public static void setUserPref(String frameId, String key, String value) {
        ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean().setPref(key, value);
    }

    public static native void setTitle(String var0);

    public static void setTitleToGadget(String frameId, String title) {
        if (title != null) {
            GadgetPortlet p = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId);
            p.setTitle(title);
        }
    }

    public static native void showFancyBox(JsArray<JavaScriptObject> var0, int var1);

    public static native void setRelayRpc(String var0, String var1);

    public static native void setAuthToken(String var0, String var1);

    public static String getSpaceId() {
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        return portal.getContainer().getSpaceId();
    }
}

