/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.bean;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
implements IsSerializable {
    private static final long serialVersionUID = 1L;
    private static final String LAYOUT_SEPARATOR = "-";
    private static final String LAYOUT_MAXGADGETS_SEPARATOR = "-max-";
    private List<GadgetBean> gadgets;
    private List<String> permissions;
    private String layout;
    private String spaceId;
    private int structure;
    private int[] maxGadgets;

    public Container() {
    }

    public Container(List<GadgetBean> gadgets, int structure, String layout, List<String> permissions, String spaceId) {
        this.gadgets = gadgets;
        this.layout = layout;
        this.structure = structure;
        this.permissions = permissions;
        this.spaceId = spaceId;
        this.computeMaxGadgets();
    }

    public List<GadgetBean> getGadgets() {
        return this.gadgets;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getLayout() {
        return this.layout;
    }

    public int getStructure() {
        return this.structure;
    }

    public void setLayout(String layout) {
        this.layout = layout;
        this.computeMaxGadgets();
    }

    public void setStructure(int structure) {
        this.structure = structure;
    }

    public List<String> getPermission() {
        return this.permissions;
    }

    public GadgetBean getGadgetBean(String ref) {
        for (GadgetBean bean : this.gadgets) {
            if (!ref.equals(bean.getRef())) continue;
            return bean;
        }
        return null;
    }

    protected void computeMaxGadgets() {
        if (this.layout.contains(LAYOUT_MAXGADGETS_SEPARATOR)) {
            this.maxGadgets = new int[this.structure];
            Arrays.fill(this.maxGadgets, -1);
            String[] maxAsStr = this.layout.split(LAYOUT_MAXGADGETS_SEPARATOR)[1].split(LAYOUT_SEPARATOR);
            for (int i = 0; i < maxAsStr.length; ++i) {
                this.maxGadgets[i] = Integer.parseInt(maxAsStr[i]);
            }
        }
    }

    public int[] getMaxGadgets() {
        return this.maxGadgets;
    }
}

