/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.service.impl;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProxySelector
extends ProxySelector {
    private static final String SHINDIG_PROXY_PROXY_PORT = "shindig.proxy.proxyPort";
    private static final String SHINDIG_PROXY_PROXY_HOST = "shindig.proxy.proxyHost";
    private static final String SHINDIG_PROXY_PROXY_SET = "shindig.proxy.proxySet";
    private static final String SHINDIG_PROXY_PASSWORD = "shindig.proxy.password";
    private static final String SHINDIG_PROXY_USER = "shindig.proxy.user";
    private static final String SHINDIG_PROXY_EXCLUDE = "shindig.proxy.excludeHost";
    private static final Log log = LogFactory.getLog(SimpleProxySelector.class);
    private Proxy proxySettings = null;
    List<String> excludedHosts = new ArrayList<String>();

    public SimpleProxySelector() {
        Object[] hosts;
        String excludedHostsProperty = Framework.getProperty((String)SHINDIG_PROXY_EXCLUDE);
        if (excludedHostsProperty != null && (hosts = excludedHostsProperty.split(",")).length > 0) {
            this.excludedHosts.addAll(Arrays.asList((Object[])hosts));
        }
        this.excludedHosts.add("localhost");
        this.excludedHosts.add("127.0.0.1");
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        boolean proxy = true;
        for (String host : this.excludedHosts) {
            if (!uri.getHost().endsWith(host)) continue;
            proxy = false;
        }
        if (!proxy) {
            proxies.add(Proxy.NO_PROXY);
        } else {
            proxies.add(this.getProxySettings());
        }
        return proxies;
    }

    private Proxy getProxySettings() {
        try {
            if (Framework.isInitialized() && SimpleProxySelector.isProxySet()) {
                if (this.proxySettings == null) {
                    SimpleProxySelector.setAuthenticator();
                    this.proxySettings = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(Framework.getProperty((String)SHINDIG_PROXY_PROXY_HOST), Integer.parseInt(Framework.getProperty((String)SHINDIG_PROXY_PROXY_PORT))));
                }
                return this.proxySettings;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get Proxy settings ", (Throwable)e);
            return Proxy.NO_PROXY;
        }
        return Proxy.NO_PROXY;
    }

    private static void setAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String password = Framework.getProperty((String)SimpleProxySelector.SHINDIG_PROXY_PASSWORD);
                if (password != null) {
                    return new PasswordAuthentication(Framework.getProperty((String)SimpleProxySelector.SHINDIG_PROXY_USER), password.toCharArray());
                }
                return null;
            }
        });
    }

    private static boolean isProxySet() {
        return Framework.getProperty((String)SHINDIG_PROXY_PROXY_SET) != null && Framework.getProperty((String)SHINDIG_PROXY_PROXY_SET).equals("true");
    }
}

