/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.crypto;

import com.google.inject.Inject;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.BlobCrypterSecurityTokenDecoder;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerIndex;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.shindig.crypto.OAuthServiceDescriptor;
import org.nuxeo.runtime.api.Framework;

public class NXBlobCrypterSecurityTokenDecoder
extends BlobCrypterSecurityTokenDecoder {
    private static final Log log = LogFactory.getLog(NXBlobCrypterSecurityTokenDecoder.class);

    @Inject
    public NXBlobCrypterSecurityTokenDecoder(ContainerConfig config, OAuthStore store) {
        super(config);
        try {
            OpenSocialService os = (OpenSocialService)Framework.getService(OpenSocialService.class);
            for (String container : config.getContainers()) {
                String key = IOUtils.toString((Reader)new FileReader(os.getSigningStateKeyFile()));
                if (key != null) {
                    BasicBlobCrypter crypter = new BasicBlobCrypter(key.getBytes());
                    this.crypters.put(container, crypter);
                } else {
                    log.error((Object)"Should not be able to run any opensocial instance without a signing state key!");
                }
                if (!(store instanceof BasicOAuthStore)) {
                    log.warn((Object)"We expected to be able to use a BasicOAuthStore to configure OAuth services!");
                    continue;
                }
                for (OAuthServiceDescriptor descrptor : os.getOAuthServices()) {
                    BasicOAuthStore oauthStore = (BasicOAuthStore)store;
                    BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
                    index.setGadgetUri(descrptor.getGadgetUrl());
                    index.setServiceName(descrptor.getServiceName());
                    String oauthKey = IOUtils.toString((Reader)new FileReader(os.getOAuthPrivateKeyFile()));
                    if (!StringUtils.isEmpty((String)descrptor.getConsumerSecret())) {
                        oauthKey = descrptor.getConsumerSecret();
                    }
                    BasicOAuthStoreConsumerKeyAndSecret keyAndSecret = new BasicOAuthStoreConsumerKeyAndSecret(descrptor.getConsumerKey(), oauthKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, os.getOAuthPrivateKeyName(), os.getOAuthCallbackUrl());
                    oauthStore.setConsumerKeyAndSecret(index, keyAndSecret);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

