/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.services;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.services.FakeNuxeoDataStore;
import org.nuxeo.opensocial.shindig.crypto.NXBlobCrypterSecurityTokenDecoder;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCryptoModule
extends AbstractModule {
    private static final Log LOG = LogFactory.getLog(NuxeoCryptoModule.class);

    protected final void configure() {
        try {
            this.bind(SecurityTokenDecoder.class).to(NXBlobCrypterSecurityTokenDecoder.class);
            this.bind(OAuthDataStore.class).to(FakeNuxeoDataStore.class);
            String signingKeyPath = ((OpenSocialService)Framework.getService(OpenSocialService.class)).getSigningStateKeyFile().getPath();
            String privateKeyPath = ((OpenSocialService)Framework.getService(OpenSocialService.class)).getOAuthPrivateKeyFile().getPath();
            String privateKeyName = ((OpenSocialService)Framework.getService(OpenSocialService.class)).getOAuthPrivateKeyName();
            String callbackUrl = ((OpenSocialService)Framework.getService(OpenSocialService.class)).getOAuthCallbackUrl();
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.state-key")).toInstance((Object)signingKeyPath);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.key-file")).toInstance((Object)privateKeyPath);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.key-name")).toInstance((Object)privateKeyName);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.global-callback-url")).toInstance((Object)callbackUrl);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to bind Shindig services to Nuxeo components", (Throwable)e);
        }
    }
}

