/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthMessage;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.oauth.api.OAuthService;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedAuthAuthenticator
implements NuxeoAuthenticationPlugin {
    protected static final String XOAUTH_SIGNATURE_PUBLIC_KEY = "xoauth_signature_publickey";
    private static final String OPENSOCIAL_VIEWER_ID = "opensocial_viewer_id";
    private static OAuthService service = null;
    private static final Log log = LogFactory.getLog(SignedAuthAuthenticator.class);

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest req, HttpServletResponse resp) {
        return this.verifyFetch(req, resp);
    }

    private UserIdentificationInfo verifyFetch(HttpServletRequest request, HttpServletResponse resp) {
        if (request.getParameter(OPENSOCIAL_VIEWER_ID) == null) {
            return null;
        }
        String consumerKey = request.getParameter(XOAUTH_SIGNATURE_PUBLIC_KEY);
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)request, null);
        try {
            if (this.getOAuthService().verify(message, consumerKey)) {
                return this.getUserIdenticationInfoFromMessage(message);
            }
            log.info((Object)"User has not been recognized : returning null ");
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private OAuthService getOAuthService() throws Exception {
        if (service == null) {
            service = (OAuthService)Framework.getService(OAuthService.class);
        }
        return service;
    }

    private UserIdentificationInfo getUserIdenticationInfoFromMessage(OAuthMessage message) {
        try {
            String userId = message.getParameter(OPENSOCIAL_VIEWER_ID);
            log.info((Object)("User has been recognized :" + userId));
            return new UserIdentificationInfo(userId, userId);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void initPlugin(Map<String, String> parameters) {
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }
}

