/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth.api.OAuthKeyDescriptor;
import org.nuxeo.ecm.platform.oauth.api.OAuthService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthServiceImpl
extends DefaultComponent
implements OAuthService {
    private Map<String, OAuthKeyDescriptor> keys = new HashMap<String, OAuthKeyDescriptor>();
    private static final String XP_KEYS = "oauthKey";
    private static final Log log = LogFactory.getLog(OAuthServiceImpl.class);

    public void activate(ComponentContext context) throws Exception {
        log.debug((Object)("Activating component : " + OAuthServiceImpl.class));
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)("Deactivating component : " + OAuthServiceImpl.class));
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_KEYS.equals(extensionPoint)) {
            OAuthKeyDescriptor keydesc = (OAuthKeyDescriptor)contribution;
            log.info((Object)("Registering key for consumer : " + keydesc.consumer));
            this.keys.put(keydesc.consumer, keydesc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_KEYS.equals(extensionPoint)) {
            OAuthKeyDescriptor keydesc = (OAuthKeyDescriptor)contribution;
            log.info((Object)("UnRegistering key for consumer : " + keydesc.consumer));
            this.keys.remove(keydesc.consumer);
        }
    }

    @Override
    public OAuthConsumer getOAuthConsumer(String consumerKey) {
        OAuthKeyDescriptor desc = this.keys.get(consumerKey);
        OAuthServiceProvider provider = new OAuthServiceProvider(null, null, null);
        OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, null, provider);
        if (!"".equals(desc.publicKey)) {
            consumer.setProperty("RSA-SHA1.PublicKey", (Object)desc.publicKey);
        }
        if (!"".equals(desc.privateKey)) {
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)desc.privateKey);
        }
        if (!"".equals(desc.certificate)) {
            consumer.setProperty("RSA-SHA1.X509Certificate", (Object)desc.certificate);
        }
        return consumer;
    }

    @Override
    public boolean verify(OAuthMessage message, String consumerKey) {
        OAuthAccessor serverAccessor = new OAuthAccessor(this.getOAuthConsumer(consumerKey));
        try {
            OAuthSignatureMethod.newSigner((OAuthMessage)message, (OAuthAccessor)serverAccessor).validate(message);
            return true;
        }
        catch (OAuthProblemException e) {
            this.logException(message, e);
        }
        catch (OAuthException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void logException(OAuthMessage message, OAuthProblemException e) {
        log.error((Object)e.getProblem(), (Throwable)e);
        try {
            log.debug((Object)("message.signature=[" + message.getSignature() + "]"));
        }
        catch (IOException e1) {
            log.error((Object)"message.signature throws IOException", (Throwable)e1);
        }
        try {
            log.debug((Object)("message.consumerKey=[" + message.getConsumerKey() + "]"));
        }
        catch (IOException e1) {
            log.error((Object)"message.consumerKey throws IOException", (Throwable)e1);
        }
        try {
            log.debug((Object)("message.signatureMethod=[" + message.getSignatureMethod() + "]"));
        }
        catch (IOException e1) {
            log.debug((Object)"message.signatureMethod throws IOException", (Throwable)e1);
        }
        try {
            log.debug((Object)("message.token=[" + message.getToken() + "]"));
        }
        catch (IOException e1) {
            log.debug((Object)"message.token throws IOException", (Throwable)e1);
        }
        Map params = e.getParameters();
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                log.info((Object)("parameter " + key + "=" + value + "."));
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(OAuthService.class)) {
            return (T)this;
        }
        return null;
    }
}

