/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.spaces.webobject;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.Univers;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.UniversNotFoundException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="spaces", facets={"Folderish"})
@Produces(value={"text/html; charset=UTF-8"})
public class SpacesModuleRoot
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(SpacesModuleRoot.class);

    public List<Univers> getUniversList() throws SpaceException, Exception {
        CoreSession session = this.getSession();
        List universList = ((SpaceManager)Framework.getService(SpaceManager.class)).getUniversList(session);
        return universList;
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @Path(value="{universeName}")
    public Object doGetUnivers(@PathParam(value="universeName") String universeName) {
        try {
            CoreSession session = this.getSession();
            SpaceManager spaceManager = (SpaceManager)Framework.getService(SpaceManager.class);
            Univers universe = spaceManager.getUnivers(universeName, session);
            return this.newObject("Univers", new Object[]{universe});
        }
        catch (UniversNotFoundException e) {
            throw new WebResourceNotFoundException("No univers " + universeName + "found", (Throwable)e);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private CoreSession getSession() {
        return WebEngine.getActiveContext().getCoreSession();
    }

    public Response handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            String fileName = "error/error_401.ftl";
            log.info((Object)fileName);
            return Response.status((int)401).entity((Object)this.getTemplate(fileName)).build();
        }
        if (e instanceof WebResourceNotFoundException) {
            String fileName = "error/error_404.ftl";
            log.info((Object)fileName);
            return Response.status((int)404).entity((Object)this.getTemplate(fileName)).build();
        }
        log.info((Object)("No error handling for class " + e.getClass().getName()));
        log.error((Object)e.getMessage(), (Throwable)e);
        return (Response)super.handleError(e);
    }
}

