/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.spaces.webobject;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.Univers;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Univers")
@Produces(value={"text/html; charset=UTF-8"})
public class UniversWebObject
extends DefaultObject {
    private Univers univers = null;
    private List<Space> spaces = null;
    private static final Log log = LogFactory.getLog(UniversWebObject.class);

    public List<Space> getSpaces() throws Exception {
        if (this.spaces == null) {
            this.spaces = ((SpaceManager)Framework.getService(SpaceManager.class)).getSpacesForUnivers(this.univers, this.getSession());
        }
        return this.spaces;
    }

    @GET
    public Response doGet() {
        try {
            List<Space> spaces = this.getSpaces();
            if (spaces.size() > 0) {
                return this.redirect(this.getPath() + "/" + spaces.get(0).getName());
            }
            throw new WebResourceNotFoundException("No space found for this universe");
        }
        catch (Exception e) {
            throw new WebResourceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public Univers getUnivers() {
        return this.univers;
    }

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        this.univers = (Univers)args[0];
    }

    @Path(value="{spacename}")
    public Resource doGetSpace(@PathParam(value="spacename") String spacename) {
        this.getContext().getRequest().setAttribute("currentUnivers", (Object)this.univers);
        try {
            CoreSession coreSession = this.getSession();
            SpaceManager spaceManager = (SpaceManager)Framework.getService(SpaceManager.class);
            Space space = spaceManager.getSpace(spacename, this.univers, coreSession);
            if (space == null) {
                throw new WebResourceNotFoundException("No space " + spacename + " found");
            }
            return this.newObject("Space", new Object[]{space});
        }
        catch (SpaceNotFoundException e) {
            throw new WebResourceNotFoundException("No space " + spacename + " found for this universe");
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private CoreSession getSession() {
        return WebEngine.getActiveContext().getCoreSession();
    }
}

