/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.spaces.webobject;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.Univers;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.DocSpaceImpl;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="Space")
@Produces(value={"text/html; charset=UTF-8"})
public class SpaceWebObject
extends DefaultObject {
    private static final Log LOGGER = LogFactory.getLog(SpaceWebObject.class);
    private Space space = null;

    public Space getSpace() {
        return this.space;
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @POST
    public Object doUpdate() {
        FormData form = this.getContext().getForm();
        String title = form.getString("dc:title");
        String description = form.getString("dc:description");
        String theme = form.getString("space:theme");
        try {
            if (title != null) {
                this.space.setTitle(title);
            }
            if (description != null) {
                this.space.setDescription(description);
            }
            if (theme != null) {
                this.space.setTheme(theme);
            }
            this.injectTheme();
            this.space.save();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        return this.getView("index");
    }

    public DocumentModel getDocument() {
        if (DocSpaceImpl.class.isAssignableFrom(this.getSpace().getClass())) {
            return ((DocSpaceImpl)this.getSpace()).getDocument();
        }
        return null;
    }

    public Univers getUnivers() {
        return (Univers)this.getContext().getRequest().getAttribute("currentUnivers");
    }

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        try {
            this.space = (Space)args[0];
            if (this.space == null) {
                throw new Exception("Space argument can't be null");
            }
            this.injectTheme();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        LOGGER.debug((Object)"Space has been set");
    }

    private void injectTheme() throws ClientException {
        if (this.space.getTheme() != null) {
            this.getContext().getRequest().setAttribute("org.nuxeo.theme.theme", (Object)(this.space.getTheme() + "/default"));
            LOGGER.debug((Object)("setting theme from space in context request wall again " + this.space.getTheme()));
        } else {
            LOGGER.debug((Object)"no theme found from space ");
        }
    }

    public String getBaseUrl() {
        HttpServletRequest request = this.getContext().getRequest();
        return VirtualHostHelper.getBaseURL((ServletRequest)request);
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter == DocumentModel.class) {
            return adapter.cast(this.getDocument());
        }
        return (A)super.getAdapter(adapter);
    }
}

