/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.runtime.api.Framework;

@Name(value="appsViews")
@Scope(value=ScopeType.CONVERSATION)
public class AppCenterViewsManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(AppCenterViewsManager.class);
    protected Map<String, String> packageTypeFilters = new HashMap<String, String>();
    protected Map<String, Boolean> platformFilters = new HashMap<String, Boolean>();
    @In(create=true)
    protected String currentAdminSubViewId;
    protected boolean onlyRemote = false;
    protected String searchString;
    protected StudioAutoInstaller studioAutoInstaller;
    protected int studioSnapshotDownloadProgress;
    protected String studioSnapshotStatus;
    protected boolean isStudioSnapshopUpdateInProgress = false;
    protected Calendar lastStudioSnapshotUpdate;
    protected String studioSnapshotUpdateError;

    public String getSearchString() {
        if (this.searchString == null) {
            return "";
        }
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean getOnlyRemote() {
        return this.onlyRemote;
    }

    public void setOnlyRemote(boolean onlyRemote) {
        this.onlyRemote = onlyRemote;
    }

    public void setPlatformFilter(boolean doFilter) {
        this.platformFilters.put(this.currentAdminSubViewId, doFilter);
    }

    public boolean getPlatformFilter() {
        Boolean dofilter = this.platformFilters.get(this.currentAdminSubViewId);
        if (dofilter == null) {
            return false;
        }
        return dofilter;
    }

    public String getPackageTypeFilter() {
        String filter = this.packageTypeFilters.get(this.currentAdminSubViewId);
        if (filter == null) {
            filter = "";
        }
        return filter;
    }

    public void setPackageTypeFilter(String filter) {
        this.packageTypeFilters.put(this.currentAdminSubViewId, filter);
    }

    public List<SelectItem> getPackageTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        SelectItem allItem = new SelectItem((Object)"", "label.packagetype.all");
        types.add(allItem);
        for (PackageType ptype : PackageType.values()) {
            SelectItem item = new SelectItem((Object)ptype.getValue(), "label.packagetype." + ptype.getValue());
            types.add(item);
        }
        return types;
    }

    public void flushCache() {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        pm.flushCache();
    }

    public void installStudioSnapshot() throws Exception {
        if (this.isStudioSnapshopUpdateInProgress) {
            return;
        }
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = pm.listAllStudioRemotePackages();
        DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
        this.studioSnapshotUpdateError = null;
        if (snapshotPkg != null) {
            this.isStudioSnapshopUpdateInProgress = true;
            DownloadingPackage downloadingStudioSnapshot = pm.download(snapshotPkg.getId());
            this.studioAutoInstaller = new StudioAutoInstaller(downloadingStudioSnapshot);
            Thread thread = new Thread(this.studioAutoInstaller);
            thread.start();
        } else {
            this.studioSnapshotUpdateError = "No snapshot package found";
        }
    }

    public boolean isStudioSnapshopUpdateInProgress() {
        return this.isStudioSnapshopUpdateInProgress;
    }

    public void checkStudioSnapshot() {
    }

    public String getStudioInstallationStatus() {
        if (this.studioSnapshotUpdateError != null) {
            return "Error : " + this.studioSnapshotUpdateError;
        }
        if ("downloading".equals(this.studioSnapshotStatus)) {
            return "downloading : " + this.studioSnapshotDownloadProgress + " %";
        }
        if ("completed".equals(this.studioSnapshotStatus)) {
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return "last update completed : " + df.format(this.lastStudioSnapshotUpdate.getTime());
        }
        return this.studioSnapshotStatus;
    }

    protected class StudioAutoInstaller
    implements Runnable {
        protected DownloadingPackage pkg;

        public StudioAutoInstaller(DownloadingPackage pkg) {
            this.pkg = pkg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AppCenterViewsManager.this.studioSnapshotStatus = "downloading";
                while (!this.pkg.isCompleted()) {
                    try {
                        AppCenterViewsManager.this.studioSnapshotDownloadProgress = this.pkg.getDownloadProgress();
                        Thread.sleep(100L);
                        log.debug((Object)"downloading studio snapshot package");
                    }
                    catch (InterruptedException e) {}
                }
                log.debug((Object)"studio snapshot package download completed, starting installation");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
                AppCenterViewsManager.this.studioSnapshotStatus = "saving";
                try {
                    while (pus.getPackage(this.pkg.getId()) == null) {
                        try {
                            AppCenterViewsManager.this.studioSnapshotDownloadProgress = this.pkg.getDownloadProgress();
                            Thread.sleep(50L);
                            log.debug((Object)"downloading studio snapshot package");
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while sending studio snapshot to update manager", (Throwable)e);
                    AppCenterViewsManager.this.studioSnapshotStatus = "error";
                    AppCenterViewsManager.this.studioSnapshotUpdateError = " problem while downloading package " + e.getMessage();
                    AppCenterViewsManager.this.studioAutoInstaller = null;
                    AppCenterViewsManager.this.isStudioSnapshopUpdateInProgress = false;
                    return;
                }
                AppCenterViewsManager.this.studioSnapshotStatus = "installing";
                try {
                    LocalPackage lpkg = pus.getPackage(this.pkg.getId());
                    Task installTask = lpkg.getInstallTask();
                    installTask.run(new HashMap());
                }
                catch (Exception e) {
                    log.error((Object)"Error while installing studio snapshot", (Throwable)e);
                    AppCenterViewsManager.this.studioSnapshotStatus = "error";
                    AppCenterViewsManager.this.studioSnapshotUpdateError = " problem during package installation " + e.getMessage();
                }
                AppCenterViewsManager.this.lastStudioSnapshotUpdate = Calendar.getInstance();
                AppCenterViewsManager.this.studioSnapshotStatus = "completed";
            }
            finally {
                AppCenterViewsManager.this.studioAutoInstaller = null;
                AppCenterViewsManager.this.isStudioSnapshopUpdateInProgress = false;
            }
        }
    }
}

