/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.work;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.work.SleepWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="workManagerAdmin")
@Scope(value=ScopeType.PAGE)
public class WorkManagerAdminBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @RequestParameter(value="queueId")
    protected String queueId;

    protected WorkManager getWorkManager() {
        return (WorkManager)Framework.getLocalService(WorkManager.class);
    }

    public List<Map<String, Object>> getWorkQueuesInfo() {
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>();
        WorkManager workManager = this.getWorkManager();
        List workQueueIds = workManager.getWorkQueueIds();
        Collections.sort(workQueueIds);
        for (String queueId : workQueueIds) {
            List running = workManager.listWork(queueId, Work.State.RUNNING);
            int scheduled = workManager.getQueueSize(queueId, Work.State.SCHEDULED);
            int completed = workManager.getQueueSize(queueId, Work.State.COMPLETED);
            HashMap<String, Object> map = new HashMap<String, Object>();
            info.add(map);
            map.put("id", queueId);
            map.put("scheduled", scheduled);
            map.put("running", running.size());
            map.put("completed", completed);
            map.put("runningWorks", running);
        }
        return info;
    }

    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public String clearQueueCompletedWork() {
        this.getWorkManager().clearCompletedWork(this.queueId);
        return null;
    }

    public String clearAllCompletedWork() {
        this.getWorkManager().clearCompletedWork(0L);
        return null;
    }

    public String startTestWork() {
        this.getWorkManager().schedule((Work)new SleepWork(10000L));
        return null;
    }
}

