/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.agenda;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AgendaEventBuilder {
    protected String summary;
    protected Date dtStart;
    protected Date dtEnd;
    protected String location;
    protected String description;
    private static final String SCHEMA_PREFIX = "vevent:";

    protected AgendaEventBuilder() {
    }

    public static AgendaEventBuilder build(String summary, Date dtStart, Date dtEnd) {
        AgendaEventBuilder AgendaEvent = new AgendaEventBuilder();
        AgendaEvent.summary(summary);
        AgendaEvent.startDate(dtStart);
        AgendaEvent.endDate(dtEnd);
        return AgendaEvent;
    }

    public AgendaEventBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public AgendaEventBuilder startDate(Date dtStart) {
        this.dtStart = this.checkDate(dtStart);
        return this;
    }

    public AgendaEventBuilder endDate(Date dtEnd) {
        this.dtEnd = this.checkDate(dtEnd);
        return this;
    }

    public AgendaEventBuilder location(String location) {
        this.location = location;
        return this;
    }

    public AgendaEventBuilder description(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("dc:title", (Serializable)((Object)this.summary));
        properties.put("dc:description", (Serializable)((Object)this.description));
        properties.put("vevent:dtstart", this.dtStart);
        properties.put("vevent:dtend", this.dtEnd);
        properties.put("vevent:location", (Serializable)((Object)this.location));
        return properties;
    }

    protected Date checkDate(Date date) {
        return date;
    }
}

