/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.tree;

import java.util.ArrayList;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.tree.VirtualNode;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;

public class NuxeoArtifactContentProvider
implements ContentProvider {
    private static final long serialVersionUID = 1L;
    protected DistributionSnapshot ds;

    public NuxeoArtifactContentProvider(DistributionSnapshot ds) {
        this.ds = ds;
    }

    public Object[] getElements(Object input) {
        return this.getChildren(input);
    }

    public Object[] getChildren(Object ob) {
        ArrayList<Object> result;
        block15: {
            NuxeoArtifact obj;
            block18: {
                block17: {
                    block16: {
                        block14: {
                            result = new ArrayList<Object>();
                            obj = (NuxeoArtifact)ob;
                            if (!obj.getArtifactType().equals("NXDistribution")) break block14;
                            for (BundleGroup bg : this.ds.getBundleGroups()) {
                                result.add(bg);
                            }
                            break block15;
                        }
                        if (!obj.getArtifactType().equals("NXBundle")) break block16;
                        for (ComponentInfo ci : this.ds.getBundle(obj.getId()).getComponents()) {
                            result.add(ci);
                        }
                        break block15;
                    }
                    if (!obj.getArtifactType().equals("NXBundleGroup")) break block17;
                    for (String bid : this.ds.getBundleGroup(obj.getId()).getBundleIds()) {
                        result.add(this.ds.getBundle(bid));
                    }
                    for (BundleGroup sbg : this.ds.getBundleGroup(obj.getId()).getSubGroups()) {
                        result.add(sbg);
                    }
                    break block15;
                }
                if (!obj.getArtifactType().equals("NXComponent")) break block18;
                ComponentInfo ci = this.ds.getComponent(obj.getId());
                if (ci.getExtensionPoints().size() > 0) {
                    result.add(new VirtualNode(ci, "ExtensionPointsContainer", "ExtensionPoints"));
                }
                if (ci.getServices().size() > 0) {
                    result.add(new VirtualNode(ci, "ServicesContainer", "Services"));
                }
                if (ci.getExtensions().size() <= 0) break block15;
                result.add(new VirtualNode(ci, "ContributionsContainer", "Contributions"));
                break block15;
            }
            if (obj.getArtifactType().equals("ExtensionPointsContainer")) {
                String cid = ((VirtualNode)obj).getComponentId();
                ComponentInfo ci = this.ds.getComponent(cid);
                for (ExtensionPointInfo epi : ci.getExtensionPoints()) {
                    result.add(epi);
                }
            } else if (obj.getArtifactType().equals("ContributionsContainer")) {
                String cid = ((VirtualNode)obj).getComponentId();
                ComponentInfo ci = this.ds.getComponent(cid);
                for (ExtensionInfo ei : ci.getExtensions()) {
                    result.add(ei);
                }
            } else if (obj.getArtifactType().equals("ServicesContainer")) {
                String cid = ((VirtualNode)obj).getComponentId();
                ComponentInfo ci = this.ds.getComponent(cid);
                for (ServiceInfo si : ci.getServices()) {
                    result.add(si);
                }
            }
        }
        return result.toArray(new NuxeoArtifact[result.size()]);
    }

    public String[] getFacets(Object object) {
        return null;
    }

    public String getLabel(Object obj) {
        String label = null;
        if (obj instanceof NuxeoArtifact) {
            NuxeoArtifact nx = (NuxeoArtifact)obj;
            label = nx.getId();
            if (nx.getArtifactType().equals("NXExtensionPoint")) {
                label = ((ExtensionPointInfo)nx).getName();
            } else if (nx.getArtifactType().equals("NXContribution")) {
                String ep;
                String[] parts = label.split("--");
                label = ep = parts[1];
            } else if (nx.getArtifactType().equals("NXService")) {
                String[] parts = label.split("\\.");
                label = parts[parts.length - 1];
            } else if (nx.getArtifactType().equals("NXBundleGroup")) {
                label = label.replace("grp:", "");
            } else if (nx.getArtifactType().equals("NXComponent")) {
                if (label.startsWith("org.nuxeo.ecm.platform.")) {
                    label = label.replace("org.nuxeo.ecm.platform.", "...");
                } else if (label.startsWith("org.nuxeo.ecm.")) {
                    label = label.replace("org.nuxeo.ecm.", "...");
                } else if (label.startsWith("org.nuxeo.")) {
                    label = label.replace("org.nuxeo.", "...");
                }
            }
        }
        return label;
    }

    public String getName(Object obj) {
        if (obj instanceof NuxeoArtifact) {
            NuxeoArtifact nx = (NuxeoArtifact)obj;
            return nx.getId();
        }
        return null;
    }

    public boolean isContainer(Object ob) {
        NuxeoArtifact obj = (NuxeoArtifact)ob;
        if (obj.getArtifactType().equals("NXExtensionPoint")) {
            return false;
        }
        if (obj.getArtifactType().equals("NXContribution")) {
            return false;
        }
        return !obj.getArtifactType().equals("NXService");
    }
}

