/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.tree;

import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.apidoc.tree.NuxeoArtifactTree;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;
import org.nuxeo.runtime.api.Framework;

public class TreeHelper {
    protected static Log log = LogFactory.getLog(TreeHelper.class);

    public static NuxeoArtifactTree getOrBuildAnonymousTree(WebContext ctx) {
        NuxeoArtifactTree tree = (NuxeoArtifactTree)((Object)ctx.getRequest().getAttribute("tree--" + ctx.getProperty("distId")));
        if (tree == null) {
            tree = TreeHelper.buildTree(ctx);
            ctx.getRequest().setAttribute("tree--" + ctx.getProperty("distId"), (Object)tree);
        }
        return tree;
    }

    public static NuxeoArtifactTree getOrBuildTree(WebContext ctx) {
        HttpSession httpSession = ctx.getRequest().getSession(true);
        NuxeoArtifactTree tree = (NuxeoArtifactTree)((Object)httpSession.getAttribute("tree--" + ctx.getProperty("distId")));
        if (tree == null) {
            tree = TreeHelper.buildTree(ctx);
            httpSession.setAttribute("tree--" + ctx.getProperty("distId"), (Object)tree);
        } else {
            tree.setDs(TreeHelper.getRequestDS(ctx));
        }
        return tree;
    }

    public static DistributionSnapshot getRequestDS(WebContext ctx) {
        String id = "tree--ds--" + ctx.getProperty("distId");
        DistributionSnapshot ds = (DistributionSnapshot)ctx.getRequest().getAttribute(id);
        if (ds == null) {
            SnapshotManager sm = (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
            ds = sm.getSnapshot((String)ctx.getProperty("distId"), ctx.getCoreSession());
            ctx.getRequest().setAttribute(id, (Object)ds);
        }
        return ds;
    }

    public static NuxeoArtifactTree buildTree(WebContext ctx) {
        DistributionSnapshot ds = TreeHelper.getRequestDS(ctx);
        return new NuxeoArtifactTree(ctx, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateTree(WebContext ctx, String source) {
        BaseNuxeoArtifactDocAdapter.setLocalCoreSession((CoreSession)ctx.getCoreSession());
        try {
            boolean anonymous = ((NuxeoPrincipal)ctx.getPrincipal()).isAnonymous();
            NuxeoArtifactTree tree = null;
            String lastPath = null;
            HttpSession httpSession = null;
            if (anonymous) {
                tree = TreeHelper.getOrBuildAnonymousTree(ctx);
            } else {
                tree = TreeHelper.getOrBuildTree(ctx);
                httpSession = ctx.getRequest().getSession(true);
                lastPath = (String)httpSession.getAttribute("tree-last-path");
            }
            if ("source".equalsIgnoreCase(source) || source == null) {
                tree.enter(ctx, "/");
                String string = tree.getTreeAsJSONArray(ctx);
                return string;
            }
            if (source.startsWith("source:")) {
                String anonymousPath = source.replace("source:", "");
                tree.enter(ctx, anonymousPath);
                String string = tree.getTreeAsJSONArray(ctx);
                return string;
            }
            if (lastPath != null) {
                TreeItem lastNode = tree.getTree().find(lastPath);
                if (lastNode != null) {
                    lastNode.collapse();
                } else {
                    log.warn((Object)("Unable to find previous selected tree node at path " + lastPath));
                }
                String lastBranch = new Path(lastPath).segment(0);
                String currentBranch = new Path(source).segment(0);
                if (!currentBranch.equals(lastBranch)) {
                    TreeItem lastBranchItem = tree.getTree().find(lastBranch);
                    if (lastBranchItem != null) {
                        lastBranchItem.collapse();
                    } else {
                        log.warn((Object)("Unable to find last branch " + lastBranch));
                    }
                }
            }
            if (httpSession != null) {
                httpSession.setAttribute("tree-last-path", (Object)source);
            }
            ctx.getRequest().setAttribute("tree-last-path", (Object)source);
            String string = tree.enter(ctx, source);
            return string;
        }
        finally {
            BaseNuxeoArtifactDocAdapter.releaseLocalCoreSession();
        }
    }
}

