/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.browse.SecurityHelper;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.export.ArchiveFile;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.DistributionSnapshotDesc;
import org.nuxeo.apidoc.snapshot.SnapshotFilter;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Path(value="/distribution")
@WebObject(type="distribution")
public class Distribution
extends ModuleRoot {
    public static final String DIST_ID = "distId";
    protected static final Log log = LogFactory.getLog(Distribution.class);

    protected SnapshotManager getSnapshotManager() {
        return (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
    }

    public String getNavigationPoint() {
        String currentUrl = this.getContext().getURL();
        String navPoint = "somewhere";
        if (currentUrl.contains("/listBundles")) {
            navPoint = "listBundles";
        } else if (currentUrl.contains("/listSeamComponents")) {
            navPoint = "listSeamComponents";
        } else if (currentUrl.contains("/viewSeamComponent")) {
            navPoint = "viewSeamComponent";
        } else if (currentUrl.contains("/listComponents")) {
            navPoint = "listComponents";
        } else if (currentUrl.contains("/listServices")) {
            navPoint = "listServices";
        } else if (currentUrl.contains("/listExtensionPoints")) {
            navPoint = "listExtensionPoints";
        } else if (currentUrl.contains("/listContributions")) {
            navPoint = "listContributions";
        } else if (currentUrl.contains("/listBundleGroups")) {
            navPoint = "listBundleGroups";
        } else if (currentUrl.contains("/viewBundleGroup")) {
            navPoint = "viewBundleGroup";
        } else if (currentUrl.contains("/viewComponent")) {
            navPoint = "viewComponent";
        } else if (currentUrl.contains("/viewService")) {
            navPoint = "viewService";
        } else if (currentUrl.contains("/viewExtensionPoint")) {
            navPoint = "viewExtensionPoint";
        } else if (currentUrl.contains("/viewContribution")) {
            navPoint = "viewContribution";
        } else if (currentUrl.contains("/viewBundle")) {
            navPoint = "viewBundle";
        } else if (currentUrl.contains("/listOperations")) {
            navPoint = "listOperations";
        } else if (currentUrl.contains("/viewOperation")) {
            navPoint = "viewOperation";
        } else if (currentUrl.contains("/doc")) {
            navPoint = "documentation";
        }
        return navPoint;
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet() {
        return this.getView("index").arg("hideNav", (Object)Boolean.TRUE);
    }

    @Path(value="{distributionId}")
    public Resource viewDistribution(@PathParam(value="distributionId") String distributionId) {
        try {
            if (distributionId == null || "".equals(distributionId)) {
                return this;
            }
            Boolean embeddedMode = Boolean.FALSE;
            if ("adm".equals(distributionId)) {
                embeddedMode = Boolean.TRUE;
            }
            this.ctx.setProperty("embeddedMode", (Object)embeddedMode);
            this.ctx.setProperty("distribution", (Object)this.getSnapshotManager().getSnapshot(distributionId, this.ctx.getCoreSession()));
            this.ctx.setProperty(DIST_ID, (Object)distributionId);
            return this.ctx.newObject("apibrowser", new Object[]{distributionId, embeddedMode});
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public List<DistributionSnapshotDesc> getAvailableDistributions() {
        return this.getSnapshotManager().getAvailableDistributions(this.ctx.getCoreSession());
    }

    public String getRuntimeDistributionName() {
        return "current";
    }

    public DistributionSnapshot getRuntimeDistribution() {
        return this.getSnapshotManager().getRuntimeSnapshot();
    }

    public Map<String, DistributionSnapshot> getPersistedDistributions() {
        return this.getSnapshotManager().getPersistentSnapshots(this.ctx.getCoreSession());
    }

    public DistributionSnapshot getCurrentDistribution() {
        String distId = (String)this.ctx.getProperty(DIST_ID);
        DistributionSnapshot currentDistribution = (DistributionSnapshot)this.ctx.getProperty("currentDistribution");
        if (currentDistribution == null || !currentDistribution.getKey().equals(distId)) {
            currentDistribution = this.getSnapshotManager().getSnapshot(distId, this.ctx.getCoreSession());
            this.ctx.setProperty("currentDistribution", (Object)currentDistribution);
        }
        return currentDistribution;
    }

    @POST
    @Path(value="save")
    @Produces(value={"text/html"})
    public Object doSave() throws Exception {
        if (!this.isEditor()) {
            return null;
        }
        log.info((Object)"Start Snapshot...");
        boolean startedTx = false;
        UserTransaction tx = TransactionHelper.lookupUserTransaction();
        if (tx != null && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            tx.begin();
            startedTx = true;
        }
        try {
            this.getSnapshotManager().persistRuntimeSnapshot(this.getContext().getCoreSession());
        }
        catch (Exception e) {
            log.error((Object)"Error during storage", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            return this.getView("index");
        }
        log.info((Object)"Snapshot saved.");
        if (tx != null && startedTx) {
            tx.commit();
        }
        return this.getView("index");
    }

    @POST
    @Path(value="saveExtended")
    @Produces(value={"text/html"})
    public Object doSaveExtended() throws Exception {
        if (!this.isEditor()) {
            return null;
        }
        FormData formData = this.getContext().getForm();
        String distribLabel = formData.getString("name");
        String bundleList = formData.getString("bundles");
        String pkgList = formData.getString("packages");
        SnapshotFilter filter = new SnapshotFilter(distribLabel);
        if (bundleList != null) {
            String[] bundles;
            for (String bundleId : bundles = bundleList.split("\n")) {
                filter.addBundlePrefix(bundleId);
            }
        }
        if (pkgList != null) {
            String[] packages;
            for (String pkg : packages = pkgList.split("\\r?\\n")) {
                filter.addPackagesPrefix(pkg);
            }
        }
        log.info((Object)"Start Snapshot...");
        boolean startedTx = false;
        UserTransaction tx = TransactionHelper.lookupUserTransaction();
        if (tx != null && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            tx.begin();
            startedTx = true;
        }
        try {
            this.getSnapshotManager().persistRuntimeSnapshot(this.getContext().getCoreSession(), distribLabel, filter);
        }
        catch (Exception e) {
            log.error((Object)"Error during storage", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            return this.getView("index");
        }
        log.info((Object)"Snapshot saved.");
        if (tx != null && startedTx) {
            tx.commit();
        }
        return this.getView("index");
    }

    public String getDocumentationInfo() throws Exception {
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        return ds.getDocumentationStats(this.getContext().getCoreSession());
    }

    protected File getExportTmpFile() {
        String fPath = System.getProperty("java.io.tmpdir") + "/export.zip";
        File tmpFile = new File(fPath);
        if (tmpFile.exists()) {
            tmpFile.delete();
            tmpFile = new File(fPath);
        }
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    @GET
    @Path(value="downloadDoc")
    public Response downloadDoc() throws Exception {
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        File tmp = this.getExportTmpFile();
        tmp.createNewFile();
        FileOutputStream out = new FileOutputStream(tmp);
        ds.exportDocumentation(this.getContext().getCoreSession(), (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
        ArchiveFile aFile = new ArchiveFile(tmp.getAbsolutePath());
        return Response.ok((Object)aFile).header("Content-Disposition", (Object)"attachment;filename=nuxeo-documentation.zip").type("application/zip").build();
    }

    @GET
    @Path(value="download/{distributionId}")
    public Response downloadDistrib(@PathParam(value="distributionId") String distribId) throws Exception {
        File tmp = this.getExportTmpFile();
        tmp.createNewFile();
        FileOutputStream out = new FileOutputStream(tmp);
        this.getSnapshotManager().exportSnapshot(this.getContext().getCoreSession(), distribId, (OutputStream)out);
        ((OutputStream)out).close();
        String fName = "nuxeo-distribution-" + distribId + ".zip";
        fName = fName.replace(" ", "_");
        ArchiveFile aFile = new ArchiveFile(tmp.getAbsolutePath());
        return Response.ok((Object)aFile).header("Content-Disposition", (Object)("attachment;filename=" + fName)).type("application/zip").build();
    }

    @POST
    @Path(value="uploadDistrib")
    @Produces(value={"text/html"})
    public Object uploadDistrib() throws Exception {
        if (!this.isEditor()) {
            return null;
        }
        Blob blob = this.getContext().getForm().getFirstBlob();
        this.getSnapshotManager().importSnapshot(this.getContext().getCoreSession(), blob.getStream());
        this.getSnapshotManager().readPersistentSnapshots(this.getContext().getCoreSession());
        return this.getView("index");
    }

    @POST
    @Path(value="uploadDoc")
    @Produces(value={"text/html"})
    public Object uploadDoc() throws Exception {
        if (!this.isEditor()) {
            return null;
        }
        UserTransaction tx = TransactionHelper.lookupUserTransaction();
        if (tx != null) {
            tx.begin();
        }
        Blob blob = this.getContext().getForm().getFirstBlob();
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        ds.importDocumentation(this.getContext().getCoreSession(), blob.getStream());
        log.info((Object)"Documents imported.");
        if (tx != null) {
            tx.commit();
        }
        return this.getView("index");
    }

    public boolean isEmbeddedMode() {
        Boolean embed = (Boolean)this.getContext().getProperty("embeddedMode", (Object)Boolean.FALSE);
        return embed == null ? false : embed;
    }

    public boolean isEditor() {
        if (this.isEmbeddedMode()) {
            return false;
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getPrincipal();
        return SecurityHelper.canEditDocumentation(principal);
    }
}

