/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.apidoc.api.AssociatedDocuments;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.browse.SecurityHelper;
import org.nuxeo.apidoc.doc.SimpleDocumentationItem;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

public abstract class NuxeoArtifactWebObject
extends DefaultObject {
    protected String nxArtifactId;

    protected void initialize(Object ... args) {
        this.nxArtifactId = (String)args[0];
    }

    protected String getNxArtifactId() {
        return this.nxArtifactId;
    }

    protected SnapshotManager getSnapshotManager() {
        return (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
    }

    public Template getView(String viewId) {
        return super.getView(viewId).arg("distId", (Object)this.getDistributionId()).arg("enableDocumentationView", (Object)Boolean.TRUE);
    }

    public abstract NuxeoArtifact getNxArtifact();

    protected abstract Object doGet() throws Exception;

    protected String getDistributionId() {
        return (String)this.ctx.getProperty("distId");
    }

    public AssociatedDocuments getAssociatedDocuments() {
        NuxeoArtifact nxItem = this.getNxArtifact();
        return nxItem.getAssociatedDocuments(this.ctx.getCoreSession());
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="updateDocumentation")
    public Object doUpdateDocumentation(DocumentationItem docItem) throws Exception {
        if (!SecurityHelper.canEditDocumentation(this.getContext())) {
            throw new WebSecurityException("You are not allowed to do this operation");
        }
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        ds.updateDocumentationItem(this.ctx.getCoreSession(), docItem);
        return this.redirect(this.getDocUrl());
    }

    protected String getDocUrl() {
        String path = this.getPath() + "/doc";
        return path;
    }

    @Deprecated
    protected String computeUrl(String suffix) throws Exception {
        String targetUrl = this.ctx.getUrlPath();
        targetUrl = URLDecoder.decode(targetUrl, "ISO-8859-1");
        targetUrl = targetUrl.replace(this.ctx.getBasePath(), "");
        targetUrl = targetUrl.replace(suffix, "/doc");
        targetUrl = URLEncoder.encode(targetUrl, "ISO-8859-1");
        return targetUrl;
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="createDocumentation")
    public Object doCreateDocumentation(DocumentationItem docItem) throws Exception {
        if (!SecurityHelper.canEditDocumentation(this.getContext())) {
            throw new WebSecurityException("You are not allowed to do this operation");
        }
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        ds.createDocumentationItem(this.ctx.getCoreSession(), this.getNxArtifact(), docItem.getTitle(), docItem.getContent(), docItem.getType(), docItem.getApplicableVersion(), docItem.isApproved(), docItem.getRenderingType());
        return this.redirect(this.getDocUrl());
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="deleteDocumentation")
    public Object doDeleteDocumentation(@FormParam(value="uuid") String uuid) throws Exception {
        if (!SecurityHelper.canEditDocumentation(this.getContext())) {
            throw new WebSecurityException("You are not allowed to do this operation");
        }
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        ds.deleteDocumentationItem(this.ctx.getCoreSession(), uuid);
        return this.redirect(this.getDocUrl());
    }

    @GET
    @Produces(value={"text/html"})
    public Object doViewDefault() throws Exception {
        NuxeoArtifact nxItem = this.getNxArtifact();
        AssociatedDocuments docs = nxItem.getAssociatedDocuments(this.ctx.getCoreSession());
        return this.getView("default").arg("nxItem", (Object)nxItem).arg("docs", (Object)docs).arg("selectedTab", (Object)"defView");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="doc")
    public Object doViewDoc() throws Exception {
        NuxeoArtifact nxItem = this.getNxArtifact();
        AssociatedDocuments docs = nxItem.getAssociatedDocuments(this.ctx.getCoreSession());
        return this.getView("../documentation").arg("nxItem", (Object)nxItem).arg("docs", (Object)docs).arg("selectedTab", (Object)"docView");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="aggregated")
    public Object doViewAggregated() throws Exception {
        NuxeoArtifact nxItem = this.getNxArtifact();
        AssociatedDocuments docs = nxItem.getAssociatedDocuments(this.ctx.getCoreSession());
        return this.getView("aggregated").arg("nxItem", (Object)nxItem).arg("docs", (Object)docs).arg("selectedTab", (Object)"aggView");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="createForm")
    public Object doAddDoc(@QueryParam(value="inline") Boolean inline, @QueryParam(value="type") String type) throws Exception {
        NuxeoArtifact nxItem = this.getNxArtifact();
        List versions = this.getSnapshotManager().getAvailableVersions(this.ctx.getCoreSession(), nxItem);
        SimpleDocumentationItem docItem = new SimpleDocumentationItem(nxItem);
        String targetView = "../docForm";
        if (inline != null && inline.equals(Boolean.TRUE)) {
            targetView = "../../docItemForm";
        }
        return this.getView(targetView).arg("nxItem", (Object)nxItem).arg("mode", (Object)"create").arg("docItem", (Object)docItem).arg("versions", (Object)versions).arg("selectedTab", (Object)"docView").arg("preselectedType", (Object)type);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="editForm/{uuid}")
    public Object doEditDoc(@PathParam(value="uuid") String uuid) throws Exception {
        NuxeoArtifact nxItem = this.getNxArtifact();
        List versions = this.getSnapshotManager().getAvailableVersions(this.ctx.getCoreSession(), nxItem);
        DocumentModel existingDoc = this.ctx.getCoreSession().getDocument((DocumentRef)new IdRef(uuid));
        DocumentationItem docItem = (DocumentationItem)existingDoc.getAdapter(DocumentationItem.class);
        return this.getView("../docForm").arg("nxItem", (Object)nxItem).arg("mode", (Object)"edit").arg("docItem", (Object)docItem).arg("versions", (Object)versions).arg("selectedTab", (Object)"docView");
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="quickEdit/{editId}")
    public Object quickEdit(@PathParam(value="editId") String editId) throws Exception {
        if (editId == null || editId.startsWith("placeholder_")) {
            return "";
        }
        DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(editId));
        DocumentationItem item = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
        return item.getContent();
    }

    @POST
    @Produces(value={"text/plain"})
    @Path(value="quickEdit/{editId}")
    public Object quickEditSave(@PathParam(value="editId") String editId) throws Exception {
        String title = this.getContext().getForm().getString("title");
        String content = this.getContext().getForm().getString("content");
        String type = this.getContext().getForm().getString("type");
        if (type == null || type.trim().length() == 0) {
            type = "description";
        }
        String renderingType = "wiki";
        if (content.contains("<ul>") || content.contains("<p>") || content.contains("<br/>")) {
            renderingType = "html";
        }
        ArrayList<String> applicableVersions = new ArrayList<String>();
        applicableVersions.add(this.getSnapshotManager().getSnapshot(this.getDistributionId(), this.getContext().getCoreSession()).getVersion());
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        if (editId == null || editId.startsWith("placeholder_")) {
            ds.createDocumentationItem(this.getContext().getCoreSession(), this.getNxArtifact(), title, content, type, applicableVersions, false, renderingType);
        } else {
            DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(editId));
            doc.setPropertyValue("dc:title", (Serializable)((Object)title));
            doc.setPropertyValue("file:content", (Serializable)new StringBlob(content));
            DocumentationItem item = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
            ds.updateDocumentationItem(this.getContext().getCoreSession(), item);
        }
        return "OK";
    }

    public Map<String, String> getCategories() throws Exception {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        return ds.getCategories();
    }
}

