/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.search.ArtifactSearcher;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="documentation")
public class DocumentationWO
extends DefaultObject {
    @GET
    @Produces(value={"text/html"})
    public Object viewAll() {
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        Map docs = ds.listDocumentationItems(this.getContext().getCoreSession(), null, null);
        return this.getView("index").arg("distId", this.ctx.getProperty("distId")).arg("docsByCat", (Object)docs);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="filter")
    public Object filterAll() {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        ArtifactSearcher searcher = (ArtifactSearcher)Framework.getService(ArtifactSearcher.class);
        List items = searcher.searchDocumentation(this.getContext().getCoreSession(), (String)this.ctx.getProperty("distId"), fulltext, null);
        Map categories = ds.getCategories();
        HashMap docs = new HashMap();
        for (DocumentationItem item : items) {
            String catKey = item.getType();
            String catLabel = (String)categories.get(catKey);
            if (docs.containsKey(catLabel)) {
                ((List)docs.get(catLabel)).add(item);
                continue;
            }
            ArrayList<DocumentationItem> itemList = new ArrayList<DocumentationItem>();
            itemList.add(item);
            docs.put(catLabel, itemList);
        }
        return this.getView("index").arg("distId", this.ctx.getProperty("distId")).arg("docsByCat", docs).arg("searchFilter", (Object)fulltext);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="view/{docUUID}")
    public Object viewDoc(@PathParam(value="docUUID") String docUUID) {
        IdRef docRef = new IdRef(docUUID);
        DocumentModel docModel = this.getContext().getCoreSession().getDocument((DocumentRef)docRef);
        DocumentationItem doc = (DocumentationItem)docModel.getAdapter(DocumentationItem.class);
        return this.getView("viewSingleDoc").arg("distId", this.ctx.getProperty("distId")).arg("doc", (Object)doc);
    }
}

