/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.classification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.classification.api.ClassificationResult;
import org.nuxeo.ecm.classification.api.ClassificationService;
import org.nuxeo.ecm.classification.api.adapter.Classification;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.classification.ClassificationActions;
import org.nuxeo.ecm.platform.classification.ClassificationTreeNode;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.DocumentModelListPageProvider;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="classificationActions")
@Scope(value=ScopeType.CONVERSATION)
public class ClassificationActionsBean
implements ClassificationActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClassificationActionsBean.class);
    @In
    protected transient FacesMessages facesMessages;
    @In
    protected transient Context eventContext;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    private transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    @In(create=true)
    protected TypesTool typesTool;
    protected DocumentModelList currentDocumentClassifications;
    protected DocumentModelList classificationRoots;
    protected DocumentModel currentClassificationRoot;
    protected DocumentTreeNode currentClassificationTree;
    protected DocumentModelList editableClassificationRoots;
    protected DocumentModel currentEditableClassificationRoot;
    protected DocumentTreeNode currentEditableClassificationTree;
    protected String currentSelectionViewId;

    protected List<DocumentModel> getFilteredSelectedDocumentsForClassification() throws ClientException {
        ClassificationService clService;
        try {
            clService = (ClassificationService)Framework.getService(ClassificationService.class);
        }
        catch (Exception e) {
            throw new ClientException("Could not find Classification Service", (Throwable)e);
        }
        DocumentModelListImpl filtered = new DocumentModelListImpl();
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (docs != null) {
            for (DocumentModel doc : docs) {
                if (doc == null || !clService.isClassifiable(doc)) continue;
                filtered.add(doc);
            }
        }
        return filtered;
    }

    public boolean getCanClassifyCurrentDocument() throws ClientException {
        return ((ClassificationService)Framework.getLocalService(ClassificationService.class)).isClassifiable(this.navigationContext.getCurrentDocument());
    }

    @Override
    public boolean getCanClassifyFromCurrentSelection() throws ClientException {
        List<DocumentModel> classifiable = this.getFilteredSelectedDocumentsForClassification();
        return !classifiable.isEmpty();
    }

    @Override
    public Collection<DocumentModel> getTargetDocuments() throws ClientException {
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>();
        res.add(this.navigationContext.getCurrentDocument());
        return res;
    }

    @Override
    public String classify(ClassificationTreeNode node) throws ClientException {
        Collection<DocumentModel> targetDocs = this.getTargetDocuments();
        if (node != null) {
            this.classify(targetDocs, node.getDocument());
            node.resetChildren();
        }
        return null;
    }

    @Override
    public Collection<DocumentModel> getMassTargetDocuments() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_FOR_CLASSIFICATION")) {
            return this.documentsListsManager.getWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION");
        }
        log.debug((Object)"No documents selection in context to process classification on");
        return null;
    }

    public void simpleClassify(ClassificationTreeNode node) throws ClientException {
        if (node != null) {
            List<DocumentModel> targetDocs = Arrays.asList(this.navigationContext.getCurrentDocument());
            this.classify(targetDocs, node.getDocument());
            node.resetChildren();
        }
    }

    @Override
    public String massClassify(ClassificationTreeNode node) throws ClientException {
        Collection<DocumentModel> targetDocs = this.getMassTargetDocuments();
        if (node != null && targetDocs != null) {
            this.classify(targetDocs, node.getDocument());
            node.resetChildren();
        }
        return null;
    }

    @Override
    public boolean classify(Collection<DocumentModel> targetDocs, DocumentModel classificationFolder) throws ClientException {
        if (targetDocs.isEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.noDocumentsToClassify"), new Object[0]);
            return true;
        }
        if (classificationFolder == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.noClassificationFolder"), new Object[0]);
            return true;
        }
        if (!classificationFolder.hasSchema("classification")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.invalidClassificationFolder"), new Object[0]);
            return true;
        }
        DocumentRef classificationRef = classificationFolder.getRef();
        if (!this.documentManager.hasPermission(classificationRef, "Classify")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.unauthorized"), new Object[0]);
            return true;
        }
        ClassificationService classificationService = (ClassificationService)Framework.getLocalService(ClassificationService.class);
        ClassificationResult classify = classificationService.classify(classificationFolder, targetDocs);
        Events.instance().raiseEvent("historyChanged", new Object[0]);
        boolean invalid = classify.contains((Enum)ClassificationService.CLASSIFY_STATE.INVALID);
        boolean alreadyClassified = classify.contains((Enum)ClassificationService.CLASSIFY_STATE.ALREADY_CLASSIFIED);
        if (invalid && alreadyClassified) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("feedback.classification.requestDoneButSomeWereAlreadyClassifiedAndSomeInvalid"), new Object[0]);
        } else if (invalid) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("feedback.classification.requestDoneButSomeInvalid"), new Object[0]);
        } else if (alreadyClassified) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("feedback.classification.requestDoneButSomeWereAlreadyClassified"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("feedback.classification.requestDone"), new Object[0]);
        }
        this.resetCurrentDocumentClassifications();
        return false;
    }

    @Override
    public String cancelClassification() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDoc);
    }

    @Override
    public String getCurrentClassificationRootId() throws ClientException {
        DocumentModel root = this.getCurrentClassificationRoot();
        if (root != null) {
            return root.getId();
        }
        return null;
    }

    @Override
    public void setCurrentClassificationRootId(String newRootId) throws ClientException {
        if (newRootId != null) {
            DocumentModelList roots = this.getClassificationRoots();
            for (DocumentModel root : roots) {
                if (!newRootId.equals(root.getId())) continue;
                this.currentClassificationRoot = root;
                break;
            }
            this.currentClassificationTree = null;
            this.eventContext.remove("currentClassificationTree");
        }
    }

    @Override
    public String navigateToCurrentClassificationRoot() throws ClientException {
        return this.navigationContext.navigateToDocument(this.currentClassificationRoot);
    }

    @Override
    public DocumentModel getCurrentClassificationRoot() throws ClientException {
        DocumentModelList roots = this.getClassificationRoots();
        if (!roots.contains((Object)this.currentClassificationRoot)) {
            this.currentClassificationRoot = null;
            this.currentClassificationTree = null;
        }
        if (this.currentClassificationRoot == null && !roots.isEmpty()) {
            this.currentClassificationRoot = (DocumentModel)roots.get(0);
        }
        return this.currentClassificationRoot;
    }

    @Override
    @Factory(value="currentEditableClassificationRootId", scope=ScopeType.EVENT)
    public String getCurrentEditableClassificationRootId() throws ClientException {
        DocumentModel root = this.getCurrentEditableClassificationRoot();
        if (root != null) {
            return root.getId();
        }
        return null;
    }

    @Override
    public void setCurrentEditableClassificationRootId(String newRootId) throws ClientException {
        if (newRootId != null) {
            DocumentModelList roots = this.getEditableClassificationRoots();
            for (DocumentModel root : roots) {
                if (!newRootId.equals(root.getId())) continue;
                this.currentEditableClassificationRoot = root;
                break;
            }
            this.currentEditableClassificationTree = null;
            this.eventContext.remove("currentEditableClassificationTree");
        }
    }

    @Override
    public DocumentModel getCurrentEditableClassificationRoot() throws ClientException {
        DocumentModelList roots;
        if (this.currentEditableClassificationRoot == null && !(roots = this.getEditableClassificationRoots()).isEmpty()) {
            this.currentEditableClassificationRoot = (DocumentModel)roots.get(0);
        }
        return this.currentEditableClassificationRoot;
    }

    @Override
    @Factory(value="currentClassificationTree", scope=ScopeType.EVENT)
    public DocumentTreeNode getCurrentClassificationTree() throws ClientException {
        DocumentModel root;
        if (this.currentClassificationTree == null && (root = this.getCurrentClassificationRoot()) != null) {
            Filter filter = null;
            Sorter sorter = null;
            try {
                TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                filter = treeManager.getFilter("classification");
                sorter = treeManager.getSorter("classification");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            this.currentClassificationTree = new DocumentTreeNodeImpl(this.documentManager.getSessionId(), root, filter, sorter);
        }
        return this.currentClassificationTree;
    }

    @Override
    @Factory(value="currentEditableClassificationTree", scope=ScopeType.EVENT)
    public DocumentTreeNode getCurrentEditableClassificationTree() throws ClientException {
        DocumentModel root;
        if (this.currentEditableClassificationTree == null && (root = this.getCurrentEditableClassificationRoot()) != null) {
            Filter filter = null;
            Sorter sorter = null;
            try {
                TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                filter = treeManager.getFilter("classification");
                sorter = treeManager.getSorter("classification");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            this.currentEditableClassificationTree = new ClassificationTreeNode(root, filter, sorter);
        }
        return this.currentEditableClassificationTree;
    }

    @Override
    @Factory(value="classificationRoots", scope=ScopeType.EVENT)
    public DocumentModelList getClassificationRoots() throws ClientException {
        if (this.classificationRoots == null) {
            this.classificationRoots = new DocumentModelListImpl();
            try {
                PageProvider<DocumentModel> provider = this.getPageProvider("CLASSIFICATION_ROOTS");
                List resultDocuments = provider.getCurrentPage();
                for (DocumentModel doc : resultDocuments) {
                    this.classificationRoots.add((Object)this.documentManager.getDocument(doc.getRef()));
                }
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return this.classificationRoots;
    }

    protected PageProvider<DocumentModel> getPageProvider(String pageProviderName) throws ClientException {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.documentManager);
        return pps.getPageProvider(pageProviderName, null, null, null, props, null);
    }

    @Override
    @Factory(value="editableClassificationRoots", scope=ScopeType.EVENT)
    public DocumentModelList getEditableClassificationRoots() throws ClientException {
        if (this.editableClassificationRoots == null) {
            this.editableClassificationRoots = new DocumentModelListImpl();
            for (DocumentModel classificationRoot : this.getClassificationRoots()) {
                DocumentRef rootRef = classificationRoot.getRef();
                if (!this.documentManager.hasPermission(rootRef, "Classify")) continue;
                this.editableClassificationRoots.add((Object)this.documentManager.getDocument(rootRef));
            }
        }
        return this.editableClassificationRoots;
    }

    @Override
    public void editableClassificationRootSelected(ValueChangeEvent event) throws ClientException {
        Object newValue = event.getNewValue();
        if (newValue instanceof String) {
            String newRootId = (String)newValue;
            this.setCurrentEditableClassificationRootId(newRootId);
        }
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentChanged", "navigateToDocument", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    public void resetClassificationData() {
        this.classificationRoots = null;
        this.currentClassificationTree = null;
        this.editableClassificationRoots = null;
        this.currentEditableClassificationRoot = null;
        this.currentEditableClassificationTree = null;
        this.resetCurrentDocumentClassifications();
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentSelectionChanged"}, create=false)
    public void resetCurrentDocumentClassifications() {
        this.currentDocumentClassifications = null;
        this.documentsListsManager.resetWorkingList("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION_FOR_UNCLASSIFICATION");
        this.contentViewActions.refresh("document_bookmark");
        this.contentViewActions.refresh("CURRENT_SELECTION_FOR_UNCLASSIFICATION");
        this.contentViewActions.refresh("bookmarked_into");
    }

    @Override
    @Factory(value="currentDocumentClassifications", scope=ScopeType.EVENT)
    public DocumentModelList getCurrentDocumentClassifications() throws ClientException {
        if (this.currentDocumentClassifications == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            Classification adapter = (Classification)currentDocument.getAdapter(Classification.class);
            this.currentDocumentClassifications = adapter.getClassifiedDocuments();
        }
        return this.currentDocumentClassifications;
    }

    @Override
    public String showCurrentSelectionClassificationForm(String currentViewId) throws ClientException {
        this.currentSelectionViewId = currentViewId;
        ContentView contentView = this.contentViewActions.getContentView("MASS_CLASSIFICATION_REQUEST");
        contentView.resetPageProvider();
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION");
        DocumentModelListPageProvider pageProvider = (DocumentModelListPageProvider)contentView.getPageProvider();
        pageProvider.setDocumentModelList(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        this.documentsListsManager.getWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION").addAll(pageProvider.getCurrentPage());
        return "current_selection_classification_request";
    }

    @Override
    public String cancelCurrentSelectionClassificationForm() throws ClientException {
        if ("/search/search_results_simple.xhtml".equals(this.currentSelectionViewId)) {
            return "search_results_simple";
        }
        if ("/search/search_results_advanced.xhtml".equals(this.currentSelectionViewId)) {
            return "search_results_advanced";
        }
        if ("/search/dynsearch_results.xhtml".equals(this.currentSelectionViewId)) {
            return "dynsearch_results";
        }
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc != null) {
            return this.navigationContext.navigateToDocument(currentDoc);
        }
        return null;
    }

    public boolean getCanUnclassifyFromCurrentSelection() {
        return !this.documentsListsManager.isWorkingListEmpty("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
    }

    public boolean getCanUnclassifyFromCurrentDocument() {
        return !this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_FOR_UNCLASSIFICATION");
    }

    @Override
    public void unclassify() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION")) {
            List toDel = this.documentsListsManager.getWorkingList("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
            ArrayList<String> targetDocIds = new ArrayList<String>();
            for (DocumentModel doc : toDel) {
                targetDocIds.add(doc.getId());
            }
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.unclassify(targetDocIds, currentDocument);
            this.resetCurrentDocumentClassifications();
        } else {
            log.warn((Object)"No documents selection in context to process unclassify on...");
        }
    }

    public void unclassifyCurrentDocument() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_FOR_UNCLASSIFICATION")) {
            List toDel = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_FOR_UNCLASSIFICATION");
            ClassificationResult classificationResult = ((ClassificationService)Framework.getLocalService(ClassificationService.class)).unClassifyFrom((Collection)toDel, this.navigationContext.getCurrentDocument().getId());
            Events.instance().raiseEvent("historyChanged", new Object[0]);
            this.resetCurrentDocumentClassifications();
            if (classificationResult.contains((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_CLASSIFIED)) {
                this.facesMessages.addFromResourceBundle(StatusMessage.Severity.WARN, "feedback.unclassification.noDocumentsToUnclassify", new Object[0]);
                return;
            }
            if (classificationResult.contains((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_ENOUGH_RIGHTS)) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("feedback.unclassification.unauthorized"), new Object[0]);
                return;
            }
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("feedback.unclassification.requestDone"), new Object[0]);
            this.resetCurrentDocumentClassifications();
        } else {
            log.warn((Object)"No documents selection in context to process unclassify on current document.");
        }
    }

    @Override
    public boolean unclassify(Collection<String> targetDocIds, DocumentModel classificationFolder) throws ClientException {
        if (targetDocIds.isEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.unclassification.noDocumentsToUnclassify"), new Object[0]);
            return true;
        }
        if (classificationFolder == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.noClassificationFolder"), new Object[0]);
            return true;
        }
        if (!classificationFolder.hasSchema("classification")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.classification.invalidClassificationFolder"), new Object[0]);
            return true;
        }
        DocumentRef classificationRef = classificationFolder.getRef();
        if (!this.documentManager.hasPermission(classificationRef, "Classify")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("feedback.unclassification.unauthorized"), new Object[0]);
            return true;
        }
        ClassificationService classificationService = (ClassificationService)Framework.getLocalService(ClassificationService.class);
        ClassificationResult listMap = classificationService.unClassify(classificationFolder, targetDocIds);
        Events.instance().raiseEvent("historyChanged", new Object[0]);
        if (listMap.contains((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_CLASSIFIED)) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("feedback.unclassification.requestDoneButSomeWereNotClassified"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("feedback.unclassification.requestDone"), new Object[0]);
        }
        this.resetCurrentDocumentClassifications();
        return false;
    }
}

