/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.offline.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.osgi.application.loader.FrameworkLoader;
import org.nuxeo.runtime.api.Framework;

public class Main {
    static final Log log = LogFactory.getLog(Main.class);
    protected File home;
    protected File wd;
    protected File bundlesDir;
    protected List<File> bundles;
    protected File config;
    protected Map<String, Object> env;
    protected Environment targetEnv;
    protected List<String> packages;
    protected PackageUpdateService pus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Main main = null;
        try {
            main = new Main(args);
            main.initialize();
            main.start();
            main.update();
        }
        catch (Throwable e) {
            log.error((Object)e);
            System.exit(2);
        }
        finally {
            if (main != null) {
                main.stop();
            }
        }
    }

    public Main(String[] args) throws Exception {
        if (args.length != 2) {
            log.error((Object)"Syntax Error: You must specify the working directory and path to upgrade file as arguments of the Main class");
            System.exit(1);
        }
        this.wd = new File(args[0]);
        this.config = new File(args[1]);
        this.home = new File(System.getProperty("nuxeo.runtime.home"));
        if (this.home == null) {
            log.error((Object)"Syntax Error: You must specify the runtime home as a System property (\"nuxeo.runtime.home\").");
            System.exit(1);
        }
        if (!this.wd.isDirectory()) {
            throw new IllegalStateException("working directory is not a directory: " + this.wd);
        }
        this.bundlesDir = new File(this.wd, "bundles");
        this.initBundleFiles();
        this.env = this.initEnvironment();
        this.packages = this.readPackages();
        if (this.packages.isEmpty()) {
            log.error((Object)("Syntax Error: No bundles found in " + this.config));
            System.exit(1);
        }
        this.targetEnv = this.createTargetEnvironment();
    }

    protected Map<String, Object> initEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        return env;
    }

    protected Environment createTargetEnvironment() {
        Environment environment = new Environment(this.home);
        environment.init();
        return environment;
    }

    protected void initBundleFiles() throws Exception {
        this.bundles = new ArrayList<File>();
        if (!this.bundlesDir.isDirectory()) {
            throw new FileNotFoundException("File " + this.bundlesDir + " is not a directory");
        }
        File[] list = this.bundlesDir.listFiles();
        if (list == null) {
            throw new FileNotFoundException("No bundles found in " + this.bundlesDir);
        }
        for (File file : list) {
            String name = file.getName();
            if (!name.endsWith(".jar") || !name.contains("nuxeo-") || name.contains("osgi")) continue;
            this.bundles.add(file);
        }
    }

    public void initialize() throws Exception {
        System.setProperty("org.nuxeo.connect.update.dataDir", this.targetEnv.getData().getAbsolutePath());
        FrameworkLoader.initialize((ClassLoader)Main.class.getClassLoader(), (File)this.wd, this.bundles, this.env);
    }

    public void start() throws Exception {
        FrameworkLoader.start();
        this.pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        if (this.pus == null) {
            throw new IllegalStateException("PackagUpdateService not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            FrameworkLoader.stop();
        }
        finally {
            if (this.config != null) {
                this.config.delete();
            }
            if (this.wd != null) {
                FileUtils.deleteTree((File)this.wd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws Exception {
        log.info((Object)"Performing update ...");
        Environment env = Environment.getDefault();
        try {
            Environment.setDefault((Environment)this.targetEnv);
            for (String pkgId : this.packages) {
                this.updatePackage(pkgId);
            }
        }
        finally {
            Environment.setDefault((Environment)env);
        }
        log.info((Object)"Done.");
    }

    protected List<String> readPackages() throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        List lines = FileUtils.readLines((File)this.config);
        for (String line : lines) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            files.add(line);
        }
        return files;
    }

    protected void updatePackage(String pkgId) throws PackageException {
        LocalPackage pkg = this.pus.getPackage(pkgId);
        if (pkg == null) {
            throw new IllegalStateException("No package found: " + pkgId);
        }
        log.info((Object)("Updating " + pkgId));
        Task installTask = pkg.getInstallTask();
        ValidationStatus status = installTask.validate();
        if (status.hasErrors()) {
            log.error((Object)("Failed to install package " + pkgId + " -> " + status.getErrors()));
            System.exit(3);
        }
        Map<String, String> params = this.getTaskParams(pkgId);
        try {
            installTask.run(params);
        }
        catch (Throwable e) {
            installTask.rollback();
            log.error((Object)("Install failed for package: " + pkgId), e);
        }
    }

    protected Map<String, String> getTaskParams(String pkgId) {
        return new HashMap<String, String>();
    }
}

