/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.impl.LocalPackageImpl;
import org.nuxeo.connect.update.task.Task;

public class PackagePersistence {
    private static final String FEATURES_DIR = "packages";
    protected File root;
    protected File store;
    protected final File temp;
    protected final Random random = new Random();
    protected Map<String, Integer> states;

    public PackagePersistence() throws IOException {
        this.root = new File(Environment.getDefault().getData(), FEATURES_DIR);
        this.root.mkdirs();
        this.store = new File(this.root, "store");
        this.store.mkdirs();
        this.temp = new File(this.root, "tmp");
        this.temp.mkdirs();
        this.states = new LinkedHashMap<String, Integer>();
        this.states = this.loadStates();
    }

    public File getRoot() {
        return this.root;
    }

    public synchronized Map<String, Integer> getStates() {
        return new HashMap<String, Integer>(this.states);
    }

    protected Map<String, Integer> loadStates() throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        File file = new File(this.root, ".packages");
        if (file.isFile()) {
            List lines = FileUtils.readLines((File)file);
            for (String line : lines) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int i = line.indexOf(61);
                String key = line.substring(0, i).trim();
                Integer val = null;
                try {
                    val = Integer.valueOf(line.substring(i + 1).trim());
                }
                catch (NumberFormatException e) {
                    val = new Integer(0);
                }
                result.put(key, val);
            }
        }
        return result;
    }

    protected void writeStates(Map<String, Integer> states) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Integer> entry : states.entrySet()) {
            buf.append(entry.getKey()).append('=').append(entry.getValue().toString()).append("\n");
        }
        File file = new File(this.root, ".packages");
        FileUtils.writeFile((File)file, (String)buf.toString());
    }

    public LocalPackage getPackage(String id) throws PackageException {
        File file = new File(this.store, id);
        if (file.isDirectory()) {
            return new LocalPackageImpl(file, this.getState(id));
        }
        return null;
    }

    public synchronized LocalPackage addPackage(File file) throws PackageException {
        if (file.isDirectory()) {
            return this.addPackageFromDir(file);
        }
        if (file.isFile()) {
            File tmp = this.newTempDir(file.getName());
            try {
                ZipUtils.unzip((File)file, (File)tmp);
                LocalPackage localPackage = this.addPackageFromDir(tmp);
                return localPackage;
            }
            catch (IOException e) {
                throw new PackageException("Faild to unzip package: " + file.getName());
            }
            finally {
                if (tmp.isDirectory()) {
                    FileUtils.deleteTree((File)tmp);
                }
            }
        }
        throw new PackageException("Not a file: " + file);
    }

    protected LocalPackage addPackageFromDir(File file) throws PackageException {
        LocalPackageImpl pkg = new LocalPackageImpl(file, 2);
        File dir = new File(this.store, pkg.getId());
        if (dir.exists()) {
            if (pkg.getId().endsWith("-0.0.0-SNAPSHOT")) {
                LocalPackage oldpkg = this.getPackage(pkg.getId());
                if (oldpkg.getState() >= 4) {
                    Task utask = oldpkg.getUninstallTask();
                    try {
                        utask.run(new HashMap());
                    }
                    catch (Throwable t) {
                        utask.rollback();
                        throw new PackageException("Failed to uninstall snapshot. Abort reloading: " + pkg.getId(), t);
                    }
                }
                FileUtils.deleteTree((File)dir);
            } else {
                throw new PackageException("Package " + pkg.getId() + " already exists");
            }
        }
        file.renameTo(dir);
        pkg.data.setRoot(dir);
        this.updateState(pkg.getId(), pkg.getState());
        return pkg;
    }

    public synchronized int getState(String featureId) throws PackageException {
        Integer state = this.states.get(featureId);
        if (state == null) {
            return 0;
        }
        return state;
    }

    public LocalPackage getActivePackage(String name) throws PackageException {
        String pkgId = this.getActivePackageId(name);
        if (pkgId == null) {
            return null;
        }
        return this.getPackage(pkgId);
    }

    public synchronized String getActivePackageId(String name) {
        name = name + '-';
        for (Map.Entry<String, Integer> entry : this.states.entrySet()) {
            if (!entry.getKey().startsWith(name) || entry.getValue() < 3) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized List<LocalPackage> getPackages() throws PackageException {
        File[] list = this.store.listFiles();
        if (list != null) {
            ArrayList<LocalPackage> pkgs = new ArrayList<LocalPackage>(list.length);
            for (File file : list) {
                pkgs.add(new LocalPackageImpl(file, this.getState(file.getName())));
            }
            return pkgs;
        }
        return new ArrayList<LocalPackage>();
    }

    public synchronized void removePackage(String id) throws PackageException {
        this.states.remove(id);
        File file = new File(this.store, id);
        if (file.isDirectory()) {
            FileUtils.deleteTree((File)file);
        }
    }

    public synchronized void updateState(String id, int state) throws PackageException {
        this.states.put(id, state);
        try {
            this.writeStates(this.states);
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File newTempDir(String id) {
        File tmp = new File(this.temp, id + "-" + this.random.nextInt());
        File file = this.temp;
        synchronized (file) {
            if (tmp.exists()) {
                return this.newTempDir(id);
            }
            tmp.mkdirs();
        }
        return tmp;
    }
}

