/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractCommand;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.commands.Undeploy;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;
import org.w3c.dom.Element;

public class Deploy
extends AbstractCommand {
    public static final String ID = "deploy";
    protected File file;

    public Deploy() {
        super(ID);
    }

    public Deploy(File file) {
        super(ID);
        this.file = file;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        try {
            ((ReloadService)Framework.getLocalService(ReloadService.class)).deployBundle(this.file);
        }
        catch (Exception e) {
            throw new PackageException("Failed to deploy bundle " + this.file, (Throwable)e);
        }
        return new Undeploy(this.file);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            this.file = new File(v);
            this.guardVars.put("file", this.file);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        writer.end();
    }
}

