/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.util;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.util.FileMatcher;

public abstract class FileRef {
    public static FileRef newFileRef(String path) {
        return FileRef.newFileRef(new File(path));
    }

    public static FileRef newFileRef(File file) {
        if (file.getName().indexOf(123) > -1) {
            return new PatternFileRef(file);
        }
        return new ExactFileRef(file);
    }

    public abstract File getFile();

    public abstract boolean hasPattern();

    public abstract void fillPatternVariables(Map<String, Object> var1);

    static class PatternFileRef
    extends FileRef {
        protected File file;
        protected String key;
        protected String value;

        public PatternFileRef(String path) {
            this(new File(path));
        }

        public PatternFileRef(File file) {
            File dir = file.getParentFile();
            File[] files = dir.listFiles();
            if (files != null) {
                FileMatcher fm = FileMatcher.getMatcher(file);
                for (File f : files) {
                    if (!fm.match(f.getName())) continue;
                    this.key = fm.getKey();
                    this.value = fm.getValue();
                    this.file = f;
                    break;
                }
            }
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean hasPattern() {
            return this.key != null;
        }

        @Override
        public void fillPatternVariables(Map<String, Object> vars) {
            if (this.key != null) {
                vars.put(this.key, this.value);
            }
        }
    }

    public static class ExactFileRef
    extends FileRef {
        protected File file;

        public ExactFileRef(String path) {
            this(new File(path));
        }

        public ExactFileRef(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean hasPattern() {
            return false;
        }

        @Override
        public void fillPatternVariables(Map<String, Object> vars) {
        }
    }
}

