/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractTask
implements Task {
    public static final String PKG_ID = "package.id";
    public static final String PKG_NAME = "package.name";
    public static final String PKG_VERSION = "package.version";
    public static final String PKG_ROOT = "package.root";
    public static final String ENV_HOME = "env.home";
    public static final String ENV_EAR = "env.ear";
    public static final String ENV_LIB = "env.lib";
    public static final String ENV_SYSLIB = "env.syslib";
    public static final String ENV_BUNDLES = "env.bundles";
    public static final String ENV_CONFIG = "env.config";
    public static final String ENV_TIMESTAMP = "sys.timestamp";
    public static final String ENV_HOSTAPP_NAME = "env.hostapp.name";
    public static final String ENV_HOSTAPP_VERSION = "env.hostapp.version";
    protected boolean restart;
    protected LocalPackage pkg;
    protected final Map<String, String> env = new HashMap<String, String>();

    protected AbstractTask() {
        Environment nxenv = Environment.getDefault();
        File home = nxenv.getHome();
        File config = nxenv.getConfig();
        this.env.put(ENV_HOME, home.getAbsolutePath());
        this.env.put(ENV_CONFIG, config.getAbsolutePath());
        this.env.put(ENV_HOSTAPP_NAME, nxenv.getHostApplicationName());
        this.env.put(ENV_HOSTAPP_VERSION, nxenv.getHostApplicationVersion());
        if (nxenv.isJBoss()) {
            File ear = config.getParentFile();
            this.env.put(ENV_EAR, ear.getAbsolutePath());
            this.env.put(ENV_LIB, new File(ear, "lib").getAbsolutePath());
            this.env.put(ENV_BUNDLES, new File(ear, "bundles").getAbsolutePath());
            String v = System.getProperty("jboss.server.home.dir");
            if (v != null) {
                this.env.put(ENV_SYSLIB, v + "/lib");
            }
        } else {
            if (nxenv.isTomcat()) {
                String v = System.getProperty("catalina.base");
                if (v != null) {
                    this.env.put(ENV_SYSLIB, v + "/lib");
                }
            } else {
                this.env.put(ENV_SYSLIB, new File(home, "lib").getAbsolutePath());
            }
            this.env.put(ENV_LIB, new File(home, "lib").getAbsolutePath());
            this.env.put(ENV_BUNDLES, new File(home, "bundles").getAbsolutePath());
        }
        this.env.put(ENV_TIMESTAMP, new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
    }

    public abstract boolean isInstallTask();

    public void initialize(LocalPackage pkg, boolean restart) throws PackageException {
        this.pkg = pkg;
        this.restart = restart;
        this.env.put(PKG_ID, pkg.getId());
        this.env.put(PKG_NAME, pkg.getName());
        this.env.put(PKG_VERSION, pkg.getVersion().toString());
        this.env.put(PKG_ROOT, pkg.getData().getRoot().getAbsolutePath());
    }

    public File getFile(String key) {
        String val = this.env.get(key);
        return val == null ? null : new File(val);
    }

    public boolean isRestartRequired() {
        return this.restart;
    }

    public LocalPackage getPackage() {
        return this.pkg;
    }

    protected Map<Object, Object> createContextMap(Map<String, String> params) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(System.getProperties());
        map.putAll(this.env);
        if (params != null && !params.isEmpty()) {
            map.putAll(params);
        }
        return map;
    }

    protected String loadParametrizedFile(File file, Map<String, String> params) throws IOException {
        String content = FileUtils.readFile((File)file);
        return StringUtils.expandVars((String)content, this.createContextMap(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveParams(Map<String, String> params) throws PackageException {
        if (params == null || params.isEmpty()) {
            return;
        }
        try {
            Properties props = new Properties();
            props.putAll(params);
            File file = this.pkg.getData().getEntry("install.properties");
            FileOutputStream out = new FileOutputStream(file);
            try {
                props.store(out, "user install parameters");
            }
            finally {
                out.close();
            }
        }
        catch (Throwable t) {
            throw new PackageException("Failed to save install parameters", t);
        }
    }

    public synchronized void run(Map<String, String> params) throws PackageException {
        LocalPackage oldpkg;
        PackageUpdateService service = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        if (this.isInstallTask() && (oldpkg = service.getActivePackage(this.pkg.getName())) != null) {
            if (oldpkg.getState() == 3) {
                throw new PackageException("Another package with the same name is installing: " + oldpkg.getName());
            }
            Task utask = oldpkg.getUninstallTask();
            try {
                utask.run(new HashMap());
            }
            catch (Throwable t) {
                utask.rollback();
                throw new PackageException("Failed to uninstall: " + oldpkg.getId() + ". Cannot continue installation of " + this.pkg.getId(), t);
            }
        }
        service.setPackageState(this.pkg, 3);
        this.saveParams(params);
        this.doRun(params);
        this.taskDone();
    }

    protected abstract void rollbackDone() throws PackageException;

    protected abstract void taskDone() throws PackageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws PackageException {
        try {
            this.doRollback();
        }
        finally {
            this.rollbackDone();
        }
    }

    public void setRestartRequired(boolean isRestartRequired) {
        this.restart = isRestartRequired;
    }

    protected abstract void doRun(Map<String, String> var1) throws PackageException;

    protected abstract void doRollback() throws PackageException;

    public ValidationStatus validate() throws PackageException {
        ValidationStatus status = new ValidationStatus();
        if (this.isInstallTask()) {
            this.validateInstall(status);
        }
        this.doValidate(status);
        return status;
    }

    public abstract void doValidate(ValidationStatus var1) throws PackageException;

    protected LocalPackage validateInstall(ValidationStatus status) throws PackageException {
        PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        LocalPackage oldpkg = pus.getActivePackage(this.pkg.getName());
        if (oldpkg != null) {
            if (oldpkg.getState() == 3) {
                status.addWarning("A package with the same name: " + oldpkg.getId() + " is being installing. Try again later.");
            } else {
                status.addWarning("The package " + oldpkg.getId() + " will be uninstalled!");
            }
            return oldpkg;
        }
        return null;
    }
}

