/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.util;

import java.util.ArrayList;
import java.util.List;

public class FileVersion
implements Comparable<FileVersion> {
    protected static final String SNAPSHOT = "-SNAPSHOT";
    protected String version;
    protected boolean snapshot;
    protected Integer[] splitVersion;
    protected String qualifier = "";
    private String separator = "";
    private String tmpVersion;

    public String getQualifier() {
        return this.qualifier;
    }

    public Integer[] getSplitVersion() {
        return this.splitVersion;
    }

    public FileVersion(String value) {
        this.version = value;
        this.snapshot = value.endsWith(SNAPSHOT);
        this.split(this.getVersionWithoutSnapshot());
    }

    public void split(String value) {
        ArrayList<Integer> versions;
        block4: {
            if (value.startsWith("r")) {
                value = value.substring(1);
            }
            versions = new ArrayList<Integer>();
            this.tmpVersion = value;
            do {
                if (!".".equals(this.separator)) continue;
                try {
                    versions.add(Integer.valueOf(this.tmpVersion));
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (this.splitWith(".", versions) || this.splitWith("-", versions) || this.splitWith("_", versions));
            this.qualifier = this.separator + this.tmpVersion;
        }
        this.splitVersion = versions.toArray(new Integer[0]);
    }

    private boolean splitWith(String token, List<Integer> versions) {
        try {
            int index = this.tmpVersion.indexOf(token);
            if (index > 0) {
                versions.add(Integer.valueOf(this.tmpVersion.substring(0, index)));
                this.separator = this.tmpVersion.substring(index, index + 1);
                this.tmpVersion = this.tmpVersion.substring(index + 1);
                return true;
            }
            if (versions.isEmpty()) {
                versions.add(Integer.valueOf(this.tmpVersion));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int compareTo(FileVersion o) {
        int oNumber;
        int number;
        int result;
        if (this.snapshot && this.getVersionWithoutSnapshot().equals(o.getVersion())) {
            return -1;
        }
        if (o.isSnapshot() && this.version.equals(o.getVersionWithoutSnapshot())) {
            return 1;
        }
        int index = 0;
        while ((result = (number = this.splitVersion.length > index ? this.splitVersion[index] : 0) - (oNumber = o.getSplitVersion().length > index ? o.getSplitVersion()[index] : 0)) == 0 && (this.splitVersion.length > ++index || o.getSplitVersion().length > index)) {
        }
        if (result == 0) {
            result = this.qualifier.compareTo(o.getQualifier());
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof FileVersion && this.compareTo((FileVersion)o) == 0;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionWithoutSnapshot() {
        if (this.snapshot) {
            return this.version.substring(0, this.version.lastIndexOf(SNAPSHOT));
        }
        return this.version;
    }

    public boolean greaterThan(FileVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean lessThan(FileVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return this.version;
    }
}

