/*
 * (C) Copyright 2012 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Anahide Tchertchian
 */
package org.nuxeo.connect.update.task.live.commands;

import java.io.File;
import java.io.IOException;
import java.util.Map;

import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.update.Rollback;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;

/**
 * @since 5.6
 */
public class RollbackAndUndeploy extends Rollback {

    // needed for deserialization
    public RollbackAndUndeploy() {
        super();
    }

    public RollbackAndUndeploy(RollbackOptions opt) {
        super(opt);
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        Command res = null;
        try {
            res = super.doRun(task, prefs);

            // then re-build the war now that jar is deleted
            ReloadService srv = Framework.getLocalService(ReloadService.class);
            srv.runDeploymentPreprocessor();
        } catch (PackageException | IOException e) {
            // ignore uninstall -> this may break the entire chain. Usually
            // uninstall is done only when rollbacking or uninstalling => force
            // restart required
            task.setRestartRequired(true);
            throw new PackageException("Failed to undeploy bundle", e);
        }
        return res;
    }

    protected Command getUndeployCommand(File targetFile) {
        return new Undeploy(targetFile);
    }

}
