/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.servlet.WSSFrontFilter;
import org.nuxeo.wss.servlet.WSSStaticResponse;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.nuxeo.wss.servlet.config.FilterBindingResolver;

public abstract class BaseWSSFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ServletContext ctx;
    protected String rootFilterTarget = null;
    public static final String ROOT_FILTER_PARAM = "org.nuxeo.wss.rootFilter";
    public static final String BACKEND_FACTORY_PARAM = "org.nuxeo.wss.backendFactory";
    public static final String FILTER_FORWARD_PARAM = "org.nuxeo.wss.forwardedFilter";
    public static final String WSSFORWARD_KEY = "WSSForward";
    private static final Log log = LogFactory.getLog(WSSFrontFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String forward;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String uri = httpRequest.getRequestURI();
            if (this.isRootFilter() && (forward = httpRequest.getParameter(WSSFORWARD_KEY)) != null) {
                httpResponse.sendRedirect(forward);
                return;
            }
            try {
                if ("OPTIONS".equals(httpRequest.getMethod())) {
                    this.handleOptionCall(httpRequest, httpResponse);
                    return;
                }
            }
            catch (Exception e) {
                throw new ServletException("Error processing request", (Throwable)e);
            }
            if (this.isRootFilter() && uri.startsWith(this.getRootFilterTarget())) {
                log.debug((Object)"Let WSS request to back filter");
                chain.doFilter(request, response);
                return;
            }
            Object forwardedConfig = httpRequest.getAttribute(FILTER_FORWARD_PARAM);
            if (forwardedConfig != null) {
                try {
                    this.handleForwardedCall(httpRequest, httpResponse, (FilterBindingConfig)forwardedConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Error processing WSS request", (Throwable)e);
                }
            }
            FilterBindingConfig config = null;
            try {
                config = FilterBindingResolver.getBinding(httpRequest);
            }
            catch (Exception e) {
                throw new ServletException("Error processing WSS request", (Throwable)e);
            }
            if (config != null) {
                try {
                    if (this.isRootFilter()) {
                        log.debug((Object)"Forward call to backend filter");
                        httpRequest.setAttribute(FILTER_FORWARD_PARAM, (Object)config);
                        this.doForward(httpRequest, httpResponse, config);
                    } else {
                        this.handleWSSCall(httpRequest, httpResponse, config);
                    }
                }
                catch (Exception e) {
                    throw new ServletException("Error processing WSS request", (Throwable)e);
                }
                return;
            }
            chain.doFilter(request, response);
        }
    }

    protected String getRootFilterTarget() {
        return this.rootFilterTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            this.ctx = filterConfig.getServletContext();
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.initHandlers(filterConfig);
            this.filterConfig = filterConfig;
            if (filterConfig != null) {
                this.initBackend(filterConfig);
            }
        }
    }

    protected void handleOptionCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        WSSStaticResponse response = new WSSStaticResponse(httpResponse);
        httpResponse.setHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        httpResponse.setHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        httpResponse.setHeader("X-MSDAVEXT", "1");
        httpResponse.setHeader("DocumentManagementServer", "Properties Schema;Source Control;Version History;");
        httpResponse.setHeader("DAV", "1,2");
        httpResponse.setHeader("Accept-Ranges", "none");
        httpResponse.setHeader("Allow", "GET, POST, OPTIONS, HEAD, MKCOL, PUT, PROPFIND, PROPPATCH, DELETE, MOVE, COPY, GETLIB, LOCK, UNLOCK");
        response.process();
    }

    protected void handleForwardedCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig forwardedConfig) throws Exception {
        log.debug((Object)"handle call forwarded by root filter");
        this.handleWSSCall(httpRequest, httpResponse, forwardedConfig);
    }

    protected abstract void initBackend(FilterConfig var1);

    protected abstract void initHandlers(FilterConfig var1);

    protected abstract boolean isRootFilter();

    protected abstract void doForward(HttpServletRequest var1, HttpServletResponse var2, FilterBindingConfig var3) throws Exception;

    protected abstract void handleWSSCall(HttpServletRequest var1, HttpServletResponse var2, FilterBindingConfig var3) throws Exception;

    public void destroy() {
    }
}

