/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import javax.servlet.http.HttpServletRequest;

public class VHHelper {
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String VH_HEADER = "nuxeo-virtual-host";

    private static String getServerUrl(String scheme, String serverName, int serverPort) {
        StringBuilder sbaseURL = new StringBuilder();
        sbaseURL.append(scheme);
        sbaseURL.append("://");
        sbaseURL.append(serverName);
        if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
            sbaseURL.append(':');
            sbaseURL.append(serverPort);
        }
        sbaseURL.append('/');
        return sbaseURL.toString();
    }

    public static boolean isVirtualHosted(HttpServletRequest httpRequest) {
        String nuxeoVH = httpRequest.getHeader(VH_HEADER);
        String forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST);
        return nuxeoVH != null || forwardedHost != null;
    }

    public static String getServerURL(HttpServletRequest httpRequest, boolean local) {
        String baseURL = null;
        if (httpRequest != null) {
            String nuxeoVH = httpRequest.getHeader(VH_HEADER);
            if (!local && nuxeoVH != null && nuxeoVH.contains("http")) {
                baseURL = nuxeoVH;
            } else {
                String forwardedHost;
                String serverName = httpRequest.getServerName();
                int serverPort = httpRequest.getServerPort();
                if (!local && (forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST)) != null) {
                    if (forwardedHost.contains(":")) {
                        serverName = forwardedHost.split(":")[0];
                        serverPort = Integer.valueOf(forwardedHost.split(":")[1]);
                    } else {
                        serverName = forwardedHost;
                        serverPort = 80;
                    }
                }
                String scheme = httpRequest.getScheme();
                baseURL = VHHelper.getServerUrl(scheme, serverName, serverPort);
            }
        }
        if (baseURL == null) {
            // empty if block
        }
        return baseURL;
    }
}

