/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fakews;

import java.util.List;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.handlers.fakews.FakeWSCmdParser;
import org.nuxeo.wss.handlers.fakews.FakeWSHandler;
import org.nuxeo.wss.handlers.fakews.FakeWSRequest;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.servlet.WSSResponse;
import org.nuxeo.wss.spi.Backend;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.Site;
import org.nuxeo.wss.url.WSSUrlMapper;
import org.nuxeo.wss.url.WSSUrlMapping;

public class FakeWebS
implements FakeWSHandler {
    public static final String pageUrl_TAG = "pageUrl";

    public void handleRequest(FakeWSRequest request, WSSResponse response) throws WSSException {
        response.addRenderingParameter("siteRoot", request.getSitePath());
        response.addRenderingParameter("request", request);
        String action = request.getAction();
        if ("http://schemas.microsoft.com/sharepoint/soap/WebUrlFromPageUrl".equals(action)) {
            String pageUrl;
            try {
                pageUrl = new FakeWSCmdParser(pageUrl_TAG).getParameter(request);
            }
            catch (Exception e) {
                throw new WSSException("Error parsing envelope", e);
            }
            response.setContentType("text/xml");
            WSSBackend backend = Backend.get(request);
            WSSUrlMapping mapping = WSSUrlMapper.getWebMapping(request, pageUrl);
            Site site = backend.getSite(mapping.getResourceUrl());
            String siteUrl = mapping.getSiteUrl() + site.getAccessUrl();
            response.addRenderingParameter("siteUrl", siteUrl);
            response.setRenderingTemplateName("WebUrlFromPageUrlResponse.ftl");
        } else if ("http://schemas.microsoft.com/sharepoint/soap/GetWebCollection".equals(action)) {
            response.setContentType("text/xml");
            WSSBackend backend = Backend.get(request);
            List<WSSListItem> items = backend.listItems("/");
            response.addRenderingParameter("sites", items);
            response.setRenderingTemplateName("GetWebCollection.ftl");
        } else {
            throw new WSSException("no FakeWS implemented for action " + action);
        }
    }

    protected String getSiteUrl(WSSRequest request, String pageUrl) {
        WSSUrlMapping mapping = WSSUrlMapper.getWebMapping(request, pageUrl);
        return mapping.getSiteUrl();
    }
}

