/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.fprpc;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCConts;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAMLHandler
extends DefaultHandler {
    protected List<FPRPCCall> calls = new ArrayList<FPRPCCall>();
    protected FPRPCCall currentCall = null;
    protected String currentParameterName = null;
    protected String currentParameterValue = null;
    public static final String METHOD_TAG = "Method";
    public static final String SETVAR_TAG = "SetVar";
    public static final String ID_ATTRIBUTE = "ID";
    public static final String NAME_ATTRIBUTE = "Name";

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (METHOD_TAG.equalsIgnoreCase(name)) {
            this.currentCall = new FPRPCCall();
            String id = attributes.getValue(ID_ATTRIBUTE);
            this.currentCall.setId(id);
        } else if (SETVAR_TAG.equalsIgnoreCase(name)) {
            this.currentParameterName = attributes.getValue(NAME_ATTRIBUTE);
            this.currentParameterValue = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentParameterName != null) {
            this.currentParameterValue = this.currentParameterValue == null ? String.valueOf(ch, start, length) : this.currentParameterValue + String.valueOf(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (METHOD_TAG.equalsIgnoreCase(name)) {
            this.calls.add(this.currentCall);
            this.currentCall = null;
        } else if (SETVAR_TAG.equalsIgnoreCase(name)) {
            if (FPRPCConts.CMD_PARAM.equalsIgnoreCase(this.currentParameterName)) {
                this.currentCall.setMethodName(this.currentParameterValue);
            } else {
                this.currentCall.addParameter(this.currentParameterName, this.currentParameterValue);
            }
            this.currentParameterName = null;
            this.currentParameterValue = null;
        }
    }

    public List<FPRPCCall> getParsedCalls() {
        return this.calls;
    }

    public static XMLReader getXMLReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        CAMLHandler handler = new CAMLHandler();
        reader.setContentHandler(handler);
        reader.setFeature("http://xml.org/sax/features/namespaces", false);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        return reader;
    }
}

