/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSBackendFactory;

public class Backend {
    protected static WSSBackendFactory factory = null;
    private static final Log log = LogFactory.getLog(Backend.class);

    public static WSSBackendFactory getFactory() {
        if (factory == null) {
            factory = Backend.loadFactory();
        }
        return factory;
    }

    protected static synchronized WSSBackendFactory loadFactory() {
        String factoryClass = WSSConfig.instance().getWssBackendFactoryClassName();
        try {
            factory = (WSSBackendFactory)Class.forName(factoryClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Unable to create backend factory", (Throwable)e);
        }
        return factory;
    }

    public static WSSBackend get(WSSRequest request) {
        return Backend.getFactory().getBackend(request);
    }
}

