/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi.dws;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.nuxeo.wss.spi.dws.DWSItem;
import org.nuxeo.wss.spi.dws.User;

public abstract class AbstractDWSItem
implements DWSItem {
    public static final SimpleDateFormat TASK_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    protected String authorId = "unset";
    protected String editorId = "unset";
    protected String authorLogin;
    protected Date created;
    protected Date modified;
    protected String fileRef;
    protected String id;

    public AbstractDWSItem(String id, String authorLogin, Date created, Date modified, String fileRef) {
        this.id = id;
        this.authorLogin = authorLogin;
        this.created = created;
        this.modified = modified;
        this.fileRef = fileRef;
    }

    @Override
    public String getAuthorRef() {
        return this.authorId + ";#" + this.getAuthorLogin();
    }

    @Override
    public String getEditorLogin() {
        return this.getAuthorLogin();
    }

    @Override
    public String getEditorRef() {
        return this.editorId + ";#" + this.getEditorLogin();
    }

    @Override
    public String getUniqueId() {
        return this.getId() + ";#{" + UUID.randomUUID().toString() + "}";
    }

    @Override
    public void updateReferences(List<User> users) {
        int i;
        for (i = 0; i < users.size(); ++i) {
            if (!users.get(i).getLogin().equals(this.getAuthorLogin())) continue;
            this.authorId = users.get(i).getId();
            break;
        }
        for (i = 0; i < users.size(); ++i) {
            if (!users.get(i).getLogin().equals(this.getEditorLogin())) continue;
            this.editorId = users.get(i).getId();
            break;
        }
    }

    @Override
    public String getCreatedTS() {
        Date date = this.getCreated();
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        return TASK_DATE_FORMAT.format(date);
    }

    @Override
    public String getModifiedTS() {
        Date date = this.getModified();
        if (date == null) {
            date = this.getCreated();
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        return TASK_DATE_FORMAT.format(date);
    }

    @Override
    public String getAuthorLogin() {
        return this.authorLogin;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public String getFileRef() {
        return this.fileRef;
    }
}

